/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.officefloor.plugin.stream.BufferPopulator;
import net.officefloor.plugin.stream.BufferSquirt;
import net.officefloor.plugin.stream.OutputBufferStream;
import net.officefloor.plugin.stream.synchronise.SynchronizedOutputStream;

public class OutputStreamOutputBufferStream
implements OutputBufferStream {
    private final OutputStream output;
    private SynchronizedOutputStream synchronizedOutput = null;

    public OutputStreamOutputBufferStream(OutputStream output) {
        this.output = output;
    }

    public synchronized OutputStream getOutputStream() {
        if (this.synchronizedOutput == null) {
            this.synchronizedOutput = new SynchronizedOutputStream(this.output, (Object)this);
        }
        return this.synchronizedOutput;
    }

    public synchronized void write(byte[] bytes) throws IOException {
        this.output.write(bytes);
    }

    public synchronized void write(byte[] data, int offset, int length) throws IOException {
        this.output.write(data, offset, length);
    }

    public void write(BufferPopulator populator) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        populator.populate(buffer);
        buffer.flip();
        this.append(buffer);
    }

    public synchronized void append(ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            this.output.write(buffer.get());
        }
    }

    public void append(BufferSquirt squirt) throws IOException {
        this.append(squirt.getBuffer());
    }

    public synchronized void close() throws IOException {
        this.output.close();
    }
}

