/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.stream.inputstream;

import java.io.IOException;
import java.io.InputStream;

public class BrowsableInputStream
extends InputStream {
    private final InputStream input;
    private final int dataBufferCapacity;
    private final Object mutex;
    private BrowseInputStream consume = null;

    public BrowsableInputStream(InputStream input, int dataBufferCapacity, Object mutex) {
        this.input = input;
        this.dataBufferCapacity = dataBufferCapacity;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createBrowser() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.consume == null) {
                this.consume = new BrowseInputStream();
            }
            return this.consume.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.consume == null) {
                return this.input.available();
            }
            return this.consume.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.consume == null) {
                return this.input.read();
            }
            return this.consume.read();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.input.close();
    }

    private class BrowseInputStream
    extends InputStream {
        private DataBuffer data;
        private int readPosition;

        public BrowseInputStream() {
            this(browsableInputStream.new DataBuffer(), 0);
        }

        private BrowseInputStream(DataBuffer data, int readPosition) {
            this.data = data;
            this.readPosition = readPosition;
        }

        public BrowseInputStream clone() {
            return new BrowseInputStream(this.data, this.readPosition);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object object = BrowsableInputStream.this.mutex;
            synchronized (object) {
                int available = 0;
                available -= this.readPosition;
                DataBuffer buffer = this.data;
                while (buffer != null) {
                    available += buffer.writePosition;
                    buffer = buffer.next;
                }
                return available += BrowsableInputStream.this.input.available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = BrowsableInputStream.this.mutex;
            synchronized (object) {
                if (this.data.data.length == this.readPosition && this.data.next != null) {
                    this.data = this.data.next;
                }
                if (this.data.writePosition > this.readPosition) {
                    return this.data.data[this.readPosition++];
                }
                int value = BrowsableInputStream.this.input.read();
                if (value == -1) {
                    return value;
                }
                if (this.data.data.length == this.data.writePosition) {
                    DataBuffer buffer;
                    this.data.next = buffer = new DataBuffer();
                    this.data = buffer;
                }
                this.data.data[((DataBuffer)this.data).writePosition++] = (byte)value;
                this.readPosition = this.data.writePosition;
                return value;
            }
        }
    }

    private class DataBuffer {
        public final byte[] data;
        private int writePosition;
        public DataBuffer next;

        private DataBuffer() {
            this.data = new byte[BrowsableInputStream.this.dataBufferCapacity];
            this.writePosition = 0;
            this.next = null;
        }
    }
}

