/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.war;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import net.officefloor.building.decorate.OfficeFloorDecorator;
import net.officefloor.building.decorate.OfficeFloorDecoratorContext;

public class WarOfficeFloorDecorator
implements OfficeFloorDecorator {
    public static final String SYSTEM_PROPERTY_PASSWORD_FILE_LOCATION = "password.file.location";
    public static final String SYSTEM_PROPERTY_HTTP_PORT = "http.port";
    public static final String WEB_INF = "WEB-INF/";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    public static final String WEB_INF_LIB = "WEB-INF/lib/";
    public static final String WEB_INF_WEB_XML = "WEB-INF/web.xml";
    public static final String WEB_PUBLIC = "WEB-PUBLIC/";

    public void decorate(OfficeFloorDecoratorContext context) throws Exception {
        File rawClassPathFile = new File(context.getRawClassPathEntry());
        if (!rawClassPathFile.exists()) {
            return;
        }
        boolean isWar = rawClassPathFile.isDirectory() ? this.decorateDirectory(rawClassPathFile, context) : this.decorateArchive(rawClassPathFile, context);
        if (isWar) {
            context.addCommandOption("officefloor", "net/officefloor/plugin/servlet/war/WarOfficeFloor.officefloor");
            String httpPort = System.getProperty(SYSTEM_PROPERTY_HTTP_PORT, "8080");
            context.addCommandOption("property", "http.port=" + httpPort);
            String passwordFileLocation = System.getProperty(SYSTEM_PROPERTY_PASSWORD_FILE_LOCATION);
            if (passwordFileLocation == null || passwordFileLocation.trim().length() == 0) {
                File passwordFile = File.createTempFile("password", ".txt");
                passwordFileLocation = passwordFile.getAbsolutePath();
                FileWriter writer = new FileWriter(passwordFileLocation);
                writer.write("algorithm=-");
                writer.close();
            }
            context.addCommandOption("property", "password.file.location=" + passwordFileLocation);
        }
    }

    private boolean decorateArchive(File rawClassPathFile, OfficeFloorDecoratorContext context) throws IOException {
        try {
            JarFile archive = new JarFile(rawClassPathFile);
            JarEntry webXml = archive.getJarEntry(WEB_INF_WEB_XML);
            if (webXml == null) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        JarInputStream input = new JarInputStream(new FileInputStream(rawClassPathFile));
        String webArchiveName = rawClassPathFile.getName();
        int extIndex = webArchiveName.lastIndexOf(46);
        if (extIndex >= 0) {
            webArchiveName = webArchiveName.substring(0, extIndex);
        }
        File warFile = File.createTempFile(webArchiveName, ".war");
        JarOutputStream output = new JarOutputStream(new FileOutputStream(warFile));
        LinkedList<String> resolvedLibEntries = new LinkedList<String>();
        JarEntry entry = input.getNextJarEntry();
        while (entry != null) {
            block12: {
                String outputName;
                byte[] data;
                block10: {
                    String entryName;
                    block11: {
                        block9: {
                            entryName = entry.getName();
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            int value = input.read();
                            while (value != -1) {
                                buffer.write(value);
                                value = input.read();
                            }
                            data = buffer.toByteArray();
                            if (!entryName.startsWith(WEB_INF_CLASSES)) break block9;
                            outputName = entryName.substring(WEB_INF_CLASSES.length());
                            break block10;
                        }
                        if (!entryName.startsWith(WEB_INF_LIB)) break block11;
                        if (entry.isDirectory()) break block12;
                        int splitIndex = entryName.lastIndexOf(47);
                        String libName = entryName.substring(splitIndex);
                        String libExtension = "jar";
                        splitIndex = libName.lastIndexOf(46);
                        if (splitIndex >= 0) {
                            libExtension = libName.substring(splitIndex);
                            libName = libName.substring(0, splitIndex);
                        }
                        File libFile = File.createTempFile(libName, libExtension);
                        FileOutputStream libOutput = new FileOutputStream(libFile);
                        libOutput.write(data);
                        libOutput.close();
                        resolvedLibEntries.add(libFile.getAbsolutePath());
                        outputName = "";
                        break block10;
                    }
                    outputName = entryName.startsWith(WEB_INF) ? entryName : WEB_PUBLIC + entryName;
                }
                if (outputName.trim().length() != 0) {
                    JarEntry jarEntry = new JarEntry(outputName);
                    jarEntry.setComment(entry.getComment());
                    jarEntry.setCompressedSize(entry.getCompressedSize());
                    jarEntry.setCrc(entry.getCrc());
                    jarEntry.setExtra(entry.getExtra());
                    jarEntry.setMethod(entry.getMethod());
                    jarEntry.setSize(entry.getSize());
                    jarEntry.setTime(entry.getTime());
                    output.putNextEntry(jarEntry);
                    output.write(data);
                }
            }
            entry = input.getNextJarEntry();
        }
        output.putNextEntry(new JarEntry(WEB_PUBLIC));
        output.close();
        input.close();
        context.includeResolvedClassPathEntry(warFile.getAbsolutePath());
        for (String resolvedLibEntry : resolvedLibEntries) {
            context.includeResolvedClassPathEntry(resolvedLibEntry);
        }
        return true;
    }

    private boolean decorateDirectory(File rawClassPathDirectory, OfficeFloorDecoratorContext context) throws IOException {
        File webXml = new File(rawClassPathDirectory, WEB_INF_WEB_XML);
        if (!webXml.isFile()) {
            return false;
        }
        File warFile = File.createTempFile(rawClassPathDirectory.getName(), ".war");
        JarOutputStream output = new JarOutputStream(new FileOutputStream(warFile));
        this.outputDirectory(rawClassPathDirectory, null, output);
        output.putNextEntry(new JarEntry(WEB_PUBLIC));
        output.close();
        context.includeResolvedClassPathEntry(warFile.getAbsolutePath());
        File libDir = new File(rawClassPathDirectory, WEB_INF_LIB);
        if (libDir.isDirectory()) {
            for (File libArchive : libDir.listFiles()) {
                context.includeResolvedClassPathEntry(libArchive.getAbsolutePath());
            }
        }
        return true;
    }

    private void outputDirectory(File root, String relativePath, JarOutputStream output) throws IOException {
        File relativeDirectory = relativePath == null ? root : new File(root, relativePath);
        for (File child : relativeDirectory.listFiles()) {
            String childPath = (relativePath == null ? "" : relativePath + "/") + child.getName();
            if (child.isDirectory()) {
                this.outputEntry(childPath + "/", new byte[0], output);
                this.outputDirectory(root, childPath, output);
                continue;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            FileInputStream input = new FileInputStream(child);
            int value = ((InputStream)input).read();
            while (value != -1) {
                buffer.write(value);
                value = ((InputStream)input).read();
            }
            ((InputStream)input).close();
            byte[] data = buffer.toByteArray();
            this.outputEntry(childPath, data, output);
        }
    }

    private void outputEntry(String rawEntryName, byte[] entryData, JarOutputStream output) throws IOException {
        String outputName;
        if (rawEntryName.startsWith(WEB_INF_CLASSES)) {
            outputName = rawEntryName.substring(WEB_INF_CLASSES.length());
        } else {
            if (rawEntryName.startsWith(WEB_INF_LIB)) {
                return;
            }
            outputName = rawEntryName.startsWith(WEB_INF) ? rawEntryName : WEB_PUBLIC + rawEntryName;
        }
        if (outputName.trim().length() == 0) {
            return;
        }
        JarEntry entry = new JarEntry(outputName);
        output.putNextEntry(entry);
        output.write(entryData);
    }
}

