/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.socket.server.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.HttpResponse;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpHeaderImpl;
import net.officefloor.plugin.stream.OutputBufferStream;
import net.officefloor.plugin.stream.outputstream.OutputStreamOutputBufferStream;

public class ServletHttpResponse
implements HttpResponse {
    private final HttpServletResponse servletResponse;
    private final List<HttpHeader> headers = new LinkedList<HttpHeader>();
    private OutputBufferStream body;

    public ServletHttpResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public synchronized HttpHeader addHeader(String name, String value) {
        HttpHeaderImpl header = new HttpHeaderImpl(name, value);
        this.servletResponse.addHeader(name, value);
        this.headers.add((HttpHeader)header);
        return header;
    }

    public synchronized HttpHeader getHeader(String name) {
        for (HttpHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public synchronized HttpHeader[] getHeaders() {
        return this.headers.toArray(new HttpHeader[this.headers.size()]);
    }

    public synchronized void removeHeader(HttpHeader header) {
        this.headers.remove(header);
        this.servletResponse.setHeader(header.getName(), null);
    }

    public synchronized void removeHeaders(String name) {
        Iterator<HttpHeader> iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            HttpHeader header = iterator.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
        this.servletResponse.setHeader(name, null);
    }

    public synchronized void setStatus(int status) {
        this.servletResponse.setStatus(status);
    }

    public void setStatus(int status, String statusMessage) {
        this.setStatus(status);
    }

    public void setVersion(String version) {
    }

    public synchronized OutputBufferStream getBody() {
        if (this.body == null) {
            ServletOutputStream outputStream;
            try {
                outputStream = this.servletResponse.getOutputStream();
            }
            catch (IOException ex) {
                outputStream = null;
            }
            this.body = new OutputStreamOutputBufferStream((OutputStream)outputStream);
        }
        return this.body;
    }

    public synchronized void send() throws IOException {
        this.servletResponse.flushBuffer();
    }
}

