/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.socket.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.officefloor.plugin.servlet.socket.server.http.ServletServerHttpConnection;
import net.officefloor.plugin.socket.server.http.HttpHeader;
import net.officefloor.plugin.socket.server.http.HttpRequest;
import net.officefloor.plugin.socket.server.http.parse.impl.HttpHeaderImpl;
import net.officefloor.plugin.stream.InputBufferStream;
import net.officefloor.plugin.stream.inputstream.InputStreamInputBufferStream;

public class ServletHttpRequest
implements HttpRequest {
    private final HttpServletRequest servletRequest;
    private List<HttpHeader> headers;
    private InputBufferStream body;

    public ServletHttpRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public String getMethod() {
        return this.servletRequest.getMethod();
    }

    public String getRequestURI() {
        return ServletServerHttpConnection.getRequestPath(this.servletRequest);
    }

    public String getVersion() {
        return this.servletRequest.getProtocol();
    }

    public synchronized List<HttpHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<HttpHeader>();
            Enumeration headerNames = this.servletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration values = this.servletRequest.getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    this.headers.add((HttpHeader)new HttpHeaderImpl(headerName, value));
                }
            }
        }
        return this.headers;
    }

    public synchronized InputBufferStream getBody() {
        if (this.body == null) {
            ServletInputStream inputStream;
            try {
                inputStream = this.servletRequest.getInputStream();
            }
            catch (IOException ex) {
                inputStream = null;
            }
            this.body = new InputStreamInputBufferStream((InputStream)inputStream);
        }
        return this.body;
    }
}

