/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.route;

import net.officefloor.frame.api.build.OfficeAwareWorkFactory;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.api.manage.Office;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.servlet.context.OfficeServletContext;
import net.officefloor.plugin.servlet.context.ServletTaskReference;
import net.officefloor.plugin.socket.server.http.HttpRequest;
import net.officefloor.plugin.socket.server.http.ServerHttpConnection;

public class ServletRouteTask
extends AbstractSingleTask<ServletRouteTask, DependencyKeys, FlowKeys>
implements OfficeAwareWorkFactory<ServletRouteTask> {
    private Office office;

    public void setOffice(Office office) {
        this.office = office;
    }

    public Object doTask(TaskContext<ServletRouteTask, DependencyKeys, FlowKeys> context) throws Exception {
        ServerHttpConnection connection = (ServerHttpConnection)context.getObject((Enum)DependencyKeys.HTTP_CONNECTION);
        HttpRequest request = connection.getHttpRequest();
        String path = request.getRequestURI();
        OfficeServletContext officeServletContext = (OfficeServletContext)context.getObject((Enum)DependencyKeys.OFFICE_SERVLET_CONTEXT);
        ServletTaskReference reference = officeServletContext.mapPath(this.office, path);
        if (reference == null) {
            context.doFlow((Enum)FlowKeys.UNHANDLED, null);
            return null;
        }
        context.doFlow(reference.getWorkName(), reference.getTaskName(), null);
        return null;
    }

    public static enum FlowKeys {
        UNHANDLED;

    }

    public static enum DependencyKeys {
        HTTP_CONNECTION,
        OFFICE_SERVLET_CONTEXT;

    }
}

