/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet.container.source;

import javax.servlet.http.HttpServlet;
import net.officefloor.compile.spi.work.source.WorkSourceContext;
import net.officefloor.compile.spi.work.source.WorkTypeBuilder;
import net.officefloor.compile.spi.work.source.impl.AbstractWorkSource;
import net.officefloor.plugin.servlet.container.source.HttpServletTask;

public class HttpServletWorkSource
extends AbstractWorkSource<HttpServletTask> {
    public static final String PROPERTY_SERVLET_NAME = "servlet.name";
    public static final String PROPERTY_SERVLET_MAPPINGS = "servlet.mappings";
    public static final String PROPERTY_HTTP_SERVLET_CLASS_NAME = "http.servlet.class.name";
    public static final String PROPERTY_PREFIX_INIT_PARAMETER = "init.parameter.";

    protected void loadSpecification(AbstractWorkSource.SpecificationContext context) {
        context.addProperty(PROPERTY_SERVLET_NAME, "Servlet Name");
        context.addProperty(PROPERTY_HTTP_SERVLET_CLASS_NAME, "Servlet Class");
        context.addProperty(PROPERTY_SERVLET_MAPPINGS, "Servlet Mappings");
    }

    public void sourceWork(WorkTypeBuilder<HttpServletTask> workTypeBuilder, WorkSourceContext context) throws Exception {
        String servletName = context.getProperty(PROPERTY_SERVLET_NAME);
        String servletClassName = context.getProperty(PROPERTY_HTTP_SERVLET_CLASS_NAME);
        context.getProperty(PROPERTY_SERVLET_MAPPINGS);
        HttpServlet servlet = (HttpServlet)context.getClassLoader().loadClass(servletClassName).newInstance();
        HttpServletTask.sourceWork(workTypeBuilder, context, servletName, servlet, new String[0]);
    }
}

