/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.plugin.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.officefloor.compile.spi.section.SectionDesigner;
import net.officefloor.compile.spi.section.SectionInput;
import net.officefloor.compile.spi.section.SectionObject;
import net.officefloor.compile.spi.section.SectionTask;
import net.officefloor.compile.spi.section.SectionWork;
import net.officefloor.compile.spi.section.TaskObject;
import net.officefloor.compile.spi.section.source.SectionSourceContext;
import net.officefloor.compile.spi.section.source.impl.AbstractSectionSource;
import net.officefloor.compile.spi.work.source.TaskTypeBuilder;
import net.officefloor.compile.spi.work.source.WorkSourceContext;
import net.officefloor.compile.spi.work.source.WorkTypeBuilder;
import net.officefloor.compile.spi.work.source.impl.AbstractWorkSource;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.build.TaskFactory;
import net.officefloor.frame.api.build.WorkFactory;
import net.officefloor.frame.api.execute.TaskContext;
import net.officefloor.frame.util.AbstractSingleTask;
import net.officefloor.plugin.servlet.bridge.ServletBridge;

public class ServletContainerResourceSectionSource
extends AbstractSectionSource {
    private static final String SERVLET_CONTAINER_RESOURCE_ATTRIBUTE_NAME = "servlet.container.resource.attribute.name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean completeServletService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContainerResourceTask task;
        HttpServletRequest httpServletRequest = request;
        synchronized (httpServletRequest) {
            task = (ServletContainerResourceTask)((Object)request.getAttribute(SERVLET_CONTAINER_RESOURCE_ATTRIBUTE_NAME));
        }
        if (task == null) {
            return true;
        }
        if (task.requestDispatcherPath != null) {
            RequestDispatcher dispatcher = request.getRequestDispatcher(task.requestDispatcherPath);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    protected void loadSpecification(AbstractSectionSource.SpecificationContext context) {
    }

    public void sourceSection(SectionDesigner designer, SectionSourceContext context) throws Exception {
        SectionObject servletBridge = designer.addSectionObject("SERVLET_BRIDGE", ServletBridge.class.getName());
        String nonHandledInputName = context.getSectionLocation();
        this.addServletResource(nonHandledInputName, null, servletBridge, designer);
        for (String inputName : context.getPropertyNames()) {
            String requestDispatcherPath = context.getProperty(inputName);
            this.addServletResource(inputName, requestDispatcherPath, servletBridge, designer);
        }
    }

    private void addServletResource(String inputName, String requestDispatcherPath, SectionObject servletBridge, SectionDesigner designer) {
        SectionWork work = designer.addSectionWork(inputName, ServletContainerResourceWorkSource.class.getName());
        work.addProperty("servlet.container.resource", requestDispatcherPath);
        SectionTask task = work.addSectionTask(inputName, "RESOURCE");
        TaskObject dependency = task.getTaskObject(DependencyKeys.SERVLET_BRIDGE.name());
        designer.link(dependency, servletBridge);
        SectionInput input = designer.addSectionInput(inputName, null);
        designer.link(input, task);
    }

    public static class ServletContainerResourceWorkSource
    extends AbstractWorkSource<ServletContainerResourceTask> {
        public static final String PROPERTY_SERVLET_CONTAINER_RESOURCE = "servlet.container.resource";

        protected void loadSpecification(AbstractWorkSource.SpecificationContext context) {
            context.addProperty(PROPERTY_SERVLET_CONTAINER_RESOURCE);
        }

        public void sourceWork(WorkTypeBuilder<ServletContainerResourceTask> workTypeBuilder, WorkSourceContext context) throws Exception {
            String requestDispatcherPath = context.getProperty(PROPERTY_SERVLET_CONTAINER_RESOURCE, null);
            ServletContainerResourceTask factory = new ServletContainerResourceTask(requestDispatcherPath);
            workTypeBuilder.setWorkFactory((WorkFactory)factory);
            TaskTypeBuilder task = workTypeBuilder.addTaskType("RESOURCE", (TaskFactory)factory, DependencyKeys.class, None.class);
            task.addObject(ServletBridge.class).setKey((Enum)DependencyKeys.SERVLET_BRIDGE);
        }
    }

    public static class ServletContainerResourceTask
    extends AbstractSingleTask<ServletContainerResourceTask, DependencyKeys, None> {
        public final String requestDispatcherPath;

        public ServletContainerResourceTask(String requestDispatcherPath) {
            this.requestDispatcherPath = requestDispatcherPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doTask(TaskContext<ServletContainerResourceTask, DependencyKeys, None> context) {
            HttpServletRequest request;
            ServletBridge bridge = (ServletBridge)context.getObject((Enum)DependencyKeys.SERVLET_BRIDGE);
            HttpServletRequest httpServletRequest = request = bridge.getRequest();
            synchronized (httpServletRequest) {
                request.setAttribute(ServletContainerResourceSectionSource.SERVLET_CONTAINER_RESOURCE_ATTRIBUTE_NAME, (Object)this);
            }
            return null;
        }
    }

    public static enum DependencyKeys {
        SERVLET_BRIDGE;

    }
}

