/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.schema.Column;
import net.odoframework.sql.util.schema.ColumnBuilder;
import net.odoframework.sql.util.schema.ManyToOneBuilder;
import net.odoframework.sql.util.schema.OneToManyBuilder;
import net.odoframework.sql.util.schema.OneToOneBuilder;
import net.odoframework.sql.util.schema.Relation;
import net.odoframework.sql.util.schema.Table;
import net.odoframework.util.ListBackedSet;
import net.odoframework.util.Strings;

public class TableBuilder<T> {
    private String name;
    private Set<Relation> relationships;
    private Map<String, Column> columns;
    private Set<Column<T, ?, ?>> primaryKey;
    private Function<Key, T> constructor;
    private Class<T> type;

    public TableBuilder(String name, Class<T> type) {
        this.name = Strings.requireNotBlank((String)name, (String)"name is required");
        this.type = Objects.requireNonNull(type, "type is required");
    }

    public static <K> TableBuilder<K> table(String name, Class<K> type) {
        TableBuilder<K> mapping = new TableBuilder<K>(name, type);
        return mapping;
    }

    public TableBuilder<T> constructor(Function<Key, T> constructor) {
        this.constructor = constructor;
        return this;
    }

    public <K> TableBuilder<T> primaryKey(String name, Function<T, K> getter, BiConsumer<T, K> setter) {
        this.getPrimaryKey().add(new Column(name, setter, getter));
        return this;
    }

    public <K> TableBuilder<T> primaryKey(String name, Function<T, K> getter) {
        return this.primaryKey(name, getter, null);
    }

    @SafeVarargs
    public final TableBuilder<T> primaryKey(Column<T, ?, ?> ... columns) {
        Set<Column> columnSet = Arrays.stream(columns).collect(Collectors.toSet());
        this.getPrimaryKey().addAll(columnSet);
        columnSet.forEach(this::column);
        return this;
    }

    public Set<Column<T, ?, ?>> getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = new ListBackedSet(1);
        }
        return this.primaryKey;
    }

    public <K, Z> TableBuilder<T> column(Column<T, K, Z> column) {
        this.initColumns();
        this.columns.put(column.getName(), column);
        return this;
    }

    private void initColumns() {
        if (this.columns == null) {
            this.columns = new LinkedHashMap<String, Column>();
        }
    }

    public <K> TableBuilder<T> column(String columnName, Function<T, K> getter, BiConsumer<T, K> setter) {
        this.initColumns();
        this.columns.put(columnName, new Column(columnName, setter, getter));
        return this;
    }

    public <K, Z> ColumnBuilder<T, K, Z> column() {
        this.initColumns();
        return new ColumnBuilder(this);
    }

    public <K, Z> TableBuilder<T> column(String columnName, Function<T, K> getter, BiConsumer<T, K> setter, Function<Z, K> dbToObjectConverter, Function<K, Z> objectToDbConverter) {
        this.initColumns();
        this.columns.put(columnName, new Column<T, K, Z>(columnName, setter, getter, dbToObjectConverter, objectToDbConverter));
        return this;
    }

    public <K> TableBuilder<T> column(String columnName, Function<T, K> getter) {
        this.initColumns();
        this.columns.put(columnName, new Column(columnName, null, getter));
        return this;
    }

    public final <K> OneToManyBuilder<T, K> oneToMany(Class<K> target) {
        return (OneToManyBuilder)((OneToManyBuilder)new OneToManyBuilder(this).owner(this.getName())).target(target);
    }

    public final TableBuilder<T> addRelation(Relation<T, ?> relation) {
        if (this.relationships == null) {
            this.relationships = new LinkedHashSet<Relation>();
        }
        this.relationships.add(Objects.requireNonNull(relation, "relation cannot be null"));
        return this;
    }

    public final <K> ManyToOneBuilder<T, K> manyToOne(Class<K> target) {
        return (ManyToOneBuilder)((ManyToOneBuilder)new ManyToOneBuilder(this).owner(this.getName())).target(target);
    }

    public final <K> OneToOneBuilder<T, K> oneToOne(Class<K> target) {
        return (OneToOneBuilder)((ManyToOneBuilder)new OneToOneBuilder(this).owner(this.getName())).target(target);
    }

    public Table<T> build() {
        Table table = new Table(this.name, this.type, this.constructor, this.primaryKey);
        this.columns.forEach((name, column) -> table.column(column));
        if (this.relationships != null) {
            this.relationships.forEach(table::addRelationship);
        }
        return table;
    }

    public String getName() {
        return this.name;
    }

    public Set<Relation> getRelationships() {
        return this.relationships;
    }

    public Map<String, Column> getColumns() {
        return this.columns;
    }

    public Function<Key, T> getConstructor() {
        return this.constructor;
    }

    public Class<T> getType() {
        return this.type;
    }
}

