/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.odoframework.sql.ColumnIndex;
import net.odoframework.sql.SQLUtils;
import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.MappingContext;
import net.odoframework.sql.util.schema.Column;
import net.odoframework.sql.util.schema.ManyToOne;
import net.odoframework.sql.util.schema.OneToMany;
import net.odoframework.sql.util.schema.PrimaryKey;
import net.odoframework.sql.util.schema.Relation;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.util.ListBackedMap;
import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

public class Table<T> {
    private final String name;
    private final PrimaryKey<T> primarykey;
    private final Function<Key, T> constructor;
    private final Class<T> type;
    private Schema schema;
    private Set<Relation<T, ?>> relationships;
    private Map<String, Column> columns;

    public Table(String name, Class<T> type, Function<Key, T> constructor, Set<Column<T, ?, ?>> primaryKey) {
        this(name, type, constructor, new PrimaryKey<T>(primaryKey));
    }

    public Table(String name, Class<T> type, Function<Key, T> constructor, PrimaryKey<T> primaryKey) {
        this.name = Strings.requireNotBlank((String)name, (String)"name is required");
        this.type = Objects.requireNonNull(type);
        this.primarykey = Objects.requireNonNull(primaryKey, "primary key cannot be null");
        if (primaryKey.size() == 0) {
            throw new IllegalArgumentException("primary key must contain at least one column");
        }
        this.constructor = Objects.requireNonNull(constructor, "constructor is required for type " + type.getName());
    }

    protected void setSchema(Schema schema) {
        this.schema = schema;
    }

    protected Map getColumns() {
        if (this.columns == null) {
            this.columns = new LinkedHashMap<String, Column>();
        }
        return this.columns;
    }

    public <K, Z> Table<T> column(Column<T, K, Z> column) {
        this.getColumns().put(column.getName(), column);
        return this;
    }

    public Set<Relation<T, ?>> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new LinkedHashSet();
        }
        return this.relationships;
    }

    public Table<T> addRelationship(Relation<T, ?> relation) {
        this.getRelationships().add(Objects.requireNonNull(relation));
        return this;
    }

    public Pair<Key, T> mapInstance(MappingContext mappingContext, ResultSet rs) {
        ColumnIndex columnIndex = mappingContext.getTableIndexMap(this.getName());
        if (columnIndex == null) {
            return null;
        }
        String[] pkColumns = this.primarykey.getPrimaryKeyColumns();
        Key primaryKey = this.primarykey.createKey(columnIndex.extract(pkColumns), rs);
        Object result = mappingContext.get(this.getName(), primaryKey).orElseGet(() -> {
            T instance = this.constructor.apply(primaryKey);
            this.primarykey.mapInstance(instance, columnIndex, rs);
            mappingContext.set(this.getName(), primaryKey, instance);
            for (String string : this.columns.keySet()) {
                Object value = SQLUtils.getColumn((ResultSet)rs, (int)((Integer)columnIndex.get((Object)string)));
                Column colDef = this.columns.get(string);
                if (!colDef.isWritable()) continue;
                colDef.setFromDB(instance, value);
            }
            for (Relation relation : this.relationships) {
                Table targetTable = this.schema.getByType(relation.getTarget());
                if (mappingContext.getTableIndexMap(targetTable.getName()) == null) continue;
                relation.map(rs, this.schema, mappingContext, primaryKey, instance);
            }
            return instance;
        });
        return Pair.cons((Object)((Object)primaryKey), (Object)result);
    }

    public Map<String, Object> toMap(T instance) {
        ListBackedMap map = new ListBackedMap(this.primarykey.size() + this.columns.size());
        this.primarykey.toMap(instance, (Map<String, Object>)map);
        for (Map.Entry<String, Column> columnEntry : this.columns.entrySet()) {
            Column column = columnEntry.getValue();
            Object value = column.getForDB(instance);
            map.put(columnEntry.getKey(), value);
        }
        this.getRelationships().stream().filter(it -> it instanceof ManyToOne).forEach(arg_0 -> this.lambda$toMap$4(instance, (Map)map, arg_0));
        return map;
    }

    public Column<T, ?, ?> getColumn(String columnName) {
        return (Column)((Object)this.getColumns().get(columnName));
    }

    public String buildJoin(int fetchDepth) {
        StringBuilder sql = new StringBuilder();
        HashSet<String> tableSet = new HashSet<String>();
        tableSet.add(this.getFullName());
        this.appendRelationships(sql, 1, fetchDepth, tableSet);
        String columns = tableSet.stream().map(it -> String.join((CharSequence)".", it, "*")).collect(Collectors.joining(", "));
        StringBuilder selectClause = new StringBuilder("select ").append(columns).append(" from ").append(this.getFullName());
        return selectClause.append('\n').append((CharSequence)sql).toString();
    }

    private void appendRelationships(StringBuilder sql, int currentDepth, int fetchDepth, Set<String> tables) {
        if (currentDepth >= fetchDepth) {
            return;
        }
        List oneToManys = this.getRelationships().stream().filter(it -> it instanceof OneToMany).collect(Collectors.toList());
        for (Relation relationship : oneToManys) {
            sql.append('\n').append(relationship.leftJoin(this.schema));
        }
        for (Relation relationship : oneToManys) {
            Table targetTable = this.getSchema().getByType(relationship.getTarget());
            targetTable.appendRelationships(sql, currentDepth + 1, fetchDepth, tables);
            tables.add(targetTable.getFullName());
        }
    }

    public String getFullName() {
        if (Strings.isNotBlank((String)this.schema.getName())) {
            return String.join((CharSequence)".", this.schema.getName(), this.getName());
        }
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public PrimaryKey<T> getPrimarykey() {
        return this.primarykey;
    }

    public Function<Key, T> getConstructor() {
        return this.constructor;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Schema getSchema() {
        return this.schema;
    }

    private /* synthetic */ void lambda$toMap$4(Object instance, Map map, Relation it) {
        ManyToOne relationship = (ManyToOne)it;
        Object relatedInstance = relationship.getGetter().apply(instance);
        if (relatedInstance != null) {
            Table<?> relatedTable = this.schema.getByType(relatedInstance.getClass());
            relationship.getColumnBindings().forEach((key, value) -> {
                Column<Object, ?, ?> column = relatedTable.getPrimarykey().getColumn((String)value).orElseThrow(() -> new IllegalStateException(value + " is not a column on " + relatedTable.name));
                map.put(key, column.getForDB(relatedInstance));
            });
        }
    }
}

