/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.odoframework.sql.util.schema.Table;
import net.odoframework.sql.util.schema.TableBuilder;
import net.odoframework.util.Strings;

public class Schema {
    private String name = "";
    private Map<String, Table> tables;

    public Schema(String name) {
        this.name = Strings.requireNotBlank((String)name, (String)"name is a required parameter");
    }

    protected Map<String, Table> getTables() {
        if (this.tables == null) {
            this.tables = new LinkedHashMap<String, Table>();
        }
        return this.tables;
    }

    public Schema add(Table<?> table) {
        table.setSchema(this);
        this.getTables().put(table.getName(), table);
        return this;
    }

    public Schema add(TableBuilder<?> table) {
        Table<?> result = table.build();
        result.setSchema(this);
        this.getTables().put(result.getName(), result);
        return this;
    }

    public <T> Table<T> getTable(String name) {
        Table theTable = this.getTables().get(name);
        if (theTable == null) {
            throw new IllegalArgumentException(name + " does not exist in the schema");
        }
        return theTable;
    }

    public <T> Table<T> getByType(Class<T> type) {
        return this.getDefn(type).orElseThrow(() -> new IllegalArgumentException(type.getName() + " is not registered"));
    }

    public <T> Optional<Table<T>> getDefn(Class<T> type) {
        return this.getTables().entrySet().stream().filter(it -> Objects.equals(type, ((Table)it.getValue()).getType())).findFirst().map(Map.Entry::getValue);
    }

    public Schema() {
    }

    public String getName() {
        return this.name;
    }
}

