/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.odoframework.sql.BaseDBStatement;
import net.odoframework.sql.ColumnIndex;
import net.odoframework.sql.SQLUtils;
import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.schema.Column;

public class PrimaryKey<T> {
    private Map<String, Column<T, ?, ?>> primaryKey = new LinkedHashMap();
    private String[] primaryKeyNamesCache = null;
    private String whereClauseCache = null;

    public PrimaryKey() {
    }

    public PrimaryKey(Set<Column<T, ?, ?>> primaryKey) {
        this();
        Objects.requireNonNull(primaryKey, "primary key cannot be null").forEach(this::add);
        if (this.primaryKey.isEmpty()) {
            throw new IllegalArgumentException("primary key must at least contain one column");
        }
    }

    public Optional<Column<T, ?, ?>> getColumn(String name) {
        return Optional.ofNullable(this.primaryKey.get(name));
    }

    public PrimaryKey<T> add(Column<T, ?, ?> column) {
        this.primaryKey.put(column.getName(), Objects.requireNonNull(column, "column argument cannot be null"));
        return this;
    }

    public String[] getPrimaryKeyColumns() {
        if (this.primaryKeyNamesCache == null) {
            this.primaryKeyNamesCache = this.primaryKey.keySet().toArray(new String[0]);
        }
        return this.primaryKeyNamesCache;
    }

    Key createKey(ColumnIndex columnIndex, ResultSet rs) {
        return Key.createKey(columnIndex.extract(this.getPrimaryKeyColumns()), rs);
    }

    void mapInstance(T instance, ColumnIndex columnIndex, ResultSet rs) {
        for (Column<T, ?, ?> pkColumn : this.primaryKey.values()) {
            if (!pkColumn.isWritable()) continue;
            pkColumn.setFromDB(instance, SQLUtils.getColumn((ResultSet)rs, (int)((Integer)columnIndex.get((Object)pkColumn.getName()))));
        }
    }

    public int size() {
        return this.primaryKey.size();
    }

    Map<String, Object> toMap(T instance, Map<String, Object> targetMap) {
        for (Column<T, ?, ?> pkColumn : this.primaryKey.values()) {
            Object value = pkColumn.getForDB(instance);
            targetMap.put(pkColumn.getName(), value);
        }
        return targetMap;
    }

    public String whereClause() {
        if (this.whereClauseCache == null) {
            this.whereClauseCache = Arrays.stream(this.getPrimaryKeyColumns()).map(it -> String.join((CharSequence)" = ", it, "?")).collect(Collectors.joining(", "));
        }
        return this.whereClauseCache;
    }

    public void populateStatement(T instance, BaseDBStatement statement) {
        this.primaryKey.values().stream().map(it -> it.getForDB(instance)).forEach(arg_0 -> ((BaseDBStatement)statement).addBinding(arg_0));
    }

    public Map<String, Column<T, ?, ?>> getPrimaryKey() {
        return this.primaryKey;
    }

    public String[] getPrimaryKeyNamesCache() {
        return this.primaryKeyNamesCache;
    }

    public String getWhereClauseCache() {
        return this.whereClauseCache;
    }

    public void setPrimaryKey(Map<String, Column<T, ?, ?>> primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setPrimaryKeyNamesCache(String[] primaryKeyNamesCache) {
        this.primaryKeyNamesCache = primaryKeyNamesCache;
    }

    public void setWhereClauseCache(String whereClauseCache) {
        this.whereClauseCache = whereClauseCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimaryKey)) {
            return false;
        }
        PrimaryKey other = (PrimaryKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Column<T, ?, ?>> this$primaryKey = this.getPrimaryKey();
        Map<String, Column<T, ?, ?>> other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPrimaryKeyNamesCache(), other.getPrimaryKeyNamesCache())) {
            return false;
        }
        String this$whereClauseCache = this.getWhereClauseCache();
        String other$whereClauseCache = other.getWhereClauseCache();
        return !(this$whereClauseCache == null ? other$whereClauseCache != null : !this$whereClauseCache.equals(other$whereClauseCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrimaryKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Column<T, ?, ?>> $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPrimaryKeyNamesCache());
        String $whereClauseCache = this.getWhereClauseCache();
        result = result * 59 + ($whereClauseCache == null ? 43 : $whereClauseCache.hashCode());
        return result;
    }

    public String toString() {
        return "PrimaryKey(primaryKey=" + this.getPrimaryKey() + ", primaryKeyNamesCache=" + Arrays.deepToString(this.getPrimaryKeyNamesCache()) + ", whereClauseCache=" + this.getWhereClauseCache() + ")";
    }
}

