/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.sql.util.schema.ManyToOne;

public class OneToOne<T, K>
extends ManyToOne<T, K> {
    public OneToOne(String name, String owner, Class<K> target, Function<T, K> getter, BiConsumer<T, K> setter, Map<String, String> columnBindings) {
        super(name, owner, target, getter, setter, columnBindings);
    }

    public static <T, K> OneToOneBuilder<T, K> builder() {
        return new OneToOneBuilder();
    }

    public static class OneToOneBuilder<T, K> {
        private String name;
        private String owner;
        private Class<K> target;
        private Function<T, K> getter;
        private BiConsumer<T, K> setter;
        private Map<String, String> columnBindings;

        OneToOneBuilder() {
        }

        public OneToOneBuilder<T, K> name(String name) {
            this.name = name;
            return this;
        }

        public OneToOneBuilder<T, K> owner(String owner) {
            this.owner = owner;
            return this;
        }

        public OneToOneBuilder<T, K> target(Class<K> target) {
            this.target = target;
            return this;
        }

        public OneToOneBuilder<T, K> getter(Function<T, K> getter) {
            this.getter = getter;
            return this;
        }

        public OneToOneBuilder<T, K> setter(BiConsumer<T, K> setter) {
            this.setter = setter;
            return this;
        }

        public OneToOneBuilder<T, K> columnBindings(Map<String, String> columnBindings) {
            this.columnBindings = columnBindings;
            return this;
        }

        public OneToOne<T, K> build() {
            return new OneToOne<T, K>(this.name, this.owner, this.target, this.getter, this.setter, this.columnBindings);
        }

        public String toString() {
            return "OneToOne.OneToOneBuilder(name=" + this.name + ", owner=" + this.owner + ", target=" + this.target + ", getter=" + this.getter + ", setter=" + this.setter + ", columnBindings=" + this.columnBindings + ")";
        }
    }
}

