/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.sql.ColumnIndex;
import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.MappingContext;
import net.odoframework.sql.util.schema.BaseRelationship;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.sql.util.schema.Table;
import net.odoframework.util.Pair;

public class OneToMany<T, K>
extends BaseRelationship<T, K> {
    private BiConsumer<T, K> setter;
    private Function<T, ? extends Collection<K>> getter;

    public OneToMany(String name, String owner, Class<K> target, Function<T, ? extends Collection<K>> getter, BiConsumer<T, K> setter, Map<String, String> columnBindings) {
        super(name, owner, target, columnBindings);
        this.getter = Objects.requireNonNull(getter, "getter is a required parameter");
        this.setter = Objects.requireNonNull(setter, "setter is a required parameter");
    }

    @Override
    public void map(ResultSet rs, Schema schema, MappingContext context, Key ownerKey, T result) {
        Table targetTable = schema.getByType(this.getTarget());
        ColumnIndex tableIndex = context.getTableIndexMap(targetTable.getName()).extract(this.columnBindings.values().toArray(new String[0]));
        Key foreignKey = Key.createKey(tableIndex, rs);
        if (foreignKey.isNull()) {
            return;
        }
        Pair targetInstance = targetTable.mapInstance(context, rs);
        if (targetInstance == null) {
            return;
        }
        boolean isSame = true;
        for (Map.Entry binding : this.columnBindings.entrySet()) {
            isSame &= Objects.equals(ownerKey.get(binding.getKey()), foreignKey.get(binding.getValue()));
        }
        if (!isSame) {
            throw new IllegalStateException(ownerKey + " didn't match " + foreignKey);
        }
        this.setter.accept(result, targetInstance.getRight());
    }

    public BiConsumer<T, K> getSetter() {
        return this.setter;
    }

    public Function<T, ? extends Collection<K>> getGetter() {
        return this.getter;
    }

    public static <T, K> OneToManyBuilder<T, K> builder() {
        return new OneToManyBuilder();
    }

    public static class OneToManyBuilder<T, K> {
        private String name;
        private String owner;
        private Class<K> target;
        private Function<T, ? extends Collection<K>> getter;
        private BiConsumer<T, K> setter;
        private Map<String, String> columnBindings;

        OneToManyBuilder() {
        }

        public OneToManyBuilder<T, K> name(String name) {
            this.name = name;
            return this;
        }

        public OneToManyBuilder<T, K> owner(String owner) {
            this.owner = owner;
            return this;
        }

        public OneToManyBuilder<T, K> target(Class<K> target) {
            this.target = target;
            return this;
        }

        public OneToManyBuilder<T, K> getter(Function<T, ? extends Collection<K>> getter) {
            this.getter = getter;
            return this;
        }

        public OneToManyBuilder<T, K> setter(BiConsumer<T, K> setter) {
            this.setter = setter;
            return this;
        }

        public OneToManyBuilder<T, K> columnBindings(Map<String, String> columnBindings) {
            this.columnBindings = columnBindings;
            return this;
        }

        public OneToMany<T, K> build() {
            return new OneToMany<T, K>(this.name, this.owner, this.target, this.getter, this.setter, this.columnBindings);
        }

        public String toString() {
            return "OneToMany.OneToManyBuilder(name=" + this.name + ", owner=" + this.owner + ", target=" + this.target + ", getter=" + this.getter + ", setter=" + this.setter + ", columnBindings=" + this.columnBindings + ")";
        }
    }
}

