/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.sql.ResultSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.sql.ColumnIndex;
import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.MappingContext;
import net.odoframework.sql.util.schema.BaseRelationship;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.sql.util.schema.Table;
import net.odoframework.util.Pair;

public class ManyToOne<T, K>
extends BaseRelationship<T, K> {
    private BiConsumer<T, K> setter;
    private Function<T, K> getter;

    public ManyToOne(String name, String owner, Class<K> target, Function<T, K> getter, BiConsumer<T, K> setter, Map<String, String> columnBindings) {
        super(name, owner, target, columnBindings);
        this.getter = Objects.requireNonNull(getter, "getter is a required parameter");
        this.setter = Objects.requireNonNull(setter, "setter is a required parameter");
    }

    @Override
    public void map(ResultSet rs, Schema schema, MappingContext context, Key ownerKey, T result) {
        Table targetTable = schema.getByType(this.getTarget());
        ColumnIndex tableIndex = context.getTableIndexMap(targetTable.getFullName()).extract(this.columnBindings.values().toArray(new String[0]));
        Key foreignKey = Key.createKey(tableIndex, rs);
        if (foreignKey.isNull()) {
            return;
        }
        Pair targetInstance = targetTable.mapInstance(context, rs);
        if (targetInstance == null) {
            return;
        }
        ColumnIndex localIndex = context.getTableIndexMap(this.getOwner()).extract(this.columnBindings.keySet().toArray(new String[0]));
        Key localKey = Key.createKey(localIndex, rs);
        boolean isSame = true;
        for (Map.Entry binding : this.columnBindings.entrySet()) {
            isSame &= Objects.equals(localKey.get(binding.getKey()), foreignKey.get(binding.getValue()));
        }
        if (!isSame) {
            throw new IllegalStateException(localKey + " didn't match " + foreignKey);
        }
        this.setter.accept(result, targetInstance.getRight());
    }

    public BiConsumer<T, K> getSetter() {
        return this.setter;
    }

    public Function<T, K> getGetter() {
        return this.getter;
    }
}

