/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.sql.util.schema.Column;
import net.odoframework.sql.util.schema.TableBuilder;
import net.odoframework.util.Strings;

public class ColumnBuilder<T, K, Z> {
    private String name;
    private Function<T, K> getter;
    private BiConsumer<T, K> setter;
    private Function<Z, K> dbToObjectConverter = z -> z;
    private Function<K, Z> objectToDbConverter = k -> k;
    private TableBuilder<T> tableBuilder;

    protected ColumnBuilder(TableBuilder<T> tableBuilder) {
        this.tableBuilder = Objects.requireNonNull(tableBuilder);
    }

    public ColumnBuilder<T, K, Z> name(String name) {
        this.name = Strings.requireNotBlank((String)name, (String)"name cannot be empty");
        return this;
    }

    public ColumnBuilder<T, K, Z> getter(Function<T, K> getter) {
        this.getter = Objects.requireNonNull(getter, "getter cannot be null");
        return this;
    }

    public ColumnBuilder<T, K, Z> fromDb(Function<Z, K> dbToObjectConverter) {
        this.dbToObjectConverter = Objects.requireNonNull(dbToObjectConverter, "dbToObjectConverter cannot be null");
        return this;
    }

    public ColumnBuilder<T, K, Z> toDb(Function<K, Z> objectToDbConverter) {
        this.objectToDbConverter = Objects.requireNonNull(objectToDbConverter, "objectToDbConverter cannot be null");
        return this;
    }

    public ColumnBuilder<T, K, Z> setter(BiConsumer<T, K> setter) {
        this.setter = Objects.requireNonNull(setter, "setter cannot be null");
        return this;
    }

    public TableBuilder<T> create() {
        this.tableBuilder.column(new Column<T, K, Z>(this.name, this.setter, this.getter, this.dbToObjectConverter, this.objectToDbConverter));
        return this.tableBuilder;
    }
}

