/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.odoframework.beans.PropertyBinding;
import net.odoframework.util.NullSafe;
import net.odoframework.util.Strings;

public class Column<T, K, Z>
extends PropertyBinding<T, K> {
    private final String name;
    private final Function<Z, K> dbToObjectConverter;
    private final Function<K, Z> objectToDbConverter;

    public Column(String name, BiConsumer<T, K> setter, Function<T, K> getter) {
        this(name, setter, getter, it -> it, it -> it);
    }

    public Column(String name, BiConsumer<T, K> setter, Function<T, K> getter, Function<Z, K> dbToObjectConverter, Function<K, Z> objectToDbConverter) {
        super(getter, setter);
        this.name = Strings.requireNotBlank((String)name, (String)"you need to specify the column name");
        this.dbToObjectConverter = (Function)NullSafe.ifNullReturn(dbToObjectConverter, it -> it);
        this.objectToDbConverter = (Function)NullSafe.ifNullReturn(objectToDbConverter, it -> it);
    }

    public Z getForDB(T instance) {
        Object value = this.get(instance);
        return value != null ? (Z)this.getObjectToDbConverter().apply(value) : null;
    }

    public void setFromDB(T instance, Z dbValue) {
        Object value = dbValue != null ? this.getDbToObjectConverter().apply(dbValue) : null;
        this.set(instance, value);
    }

    protected void checkValid() {
    }

    public boolean isWritable() {
        return this.setter != null;
    }

    public boolean isReadable() {
        return this.getter != null;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", dbToObjectConverter=" + this.getDbToObjectConverter() + ", objectToDbConverter=" + this.getObjectToDbConverter() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Function<Z, K> this$dbToObjectConverter = this.getDbToObjectConverter();
        Function<Z, K> other$dbToObjectConverter = other.getDbToObjectConverter();
        if (this$dbToObjectConverter == null ? other$dbToObjectConverter != null : !this$dbToObjectConverter.equals(other$dbToObjectConverter)) {
            return false;
        }
        Function<K, Z> this$objectToDbConverter = this.getObjectToDbConverter();
        Function<K, Z> other$objectToDbConverter = other.getObjectToDbConverter();
        return !(this$objectToDbConverter == null ? other$objectToDbConverter != null : !this$objectToDbConverter.equals(other$objectToDbConverter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Function<Z, K> $dbToObjectConverter = this.getDbToObjectConverter();
        result = result * 59 + ($dbToObjectConverter == null ? 43 : $dbToObjectConverter.hashCode());
        Function<K, Z> $objectToDbConverter = this.getObjectToDbConverter();
        result = result * 59 + ($objectToDbConverter == null ? 43 : $objectToDbConverter.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Function<Z, K> getDbToObjectConverter() {
        return this.dbToObjectConverter;
    }

    public Function<K, Z> getObjectToDbConverter() {
        return this.objectToDbConverter;
    }
}

