/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.odoframework.sql.util.schema.TableBuilder;
import net.odoframework.util.Pair;

public class BaseRelationshipBuilder<T, K, Z extends BaseRelationshipBuilder<T, K, Z>> {
    protected String name;
    protected String owner;
    protected Class<K> target;
    protected Map<String, String> columnBindings;
    protected TableBuilder<T> builder;
    protected BiConsumer<T, K> setter;

    public BaseRelationshipBuilder(TableBuilder<T> builder) {
        this.builder = Objects.requireNonNull(builder);
    }

    public Z name(String name) {
        this.name = name;
        return (Z)this;
    }

    public Z owner(String owner) {
        this.owner = owner;
        return (Z)this;
    }

    public Z target(Class<K> target) {
        this.target = target;
        return (Z)this;
    }

    public Z mapColumns(Map<String, String> columnBindings) {
        this.columnBindings = columnBindings;
        return (Z)this;
    }

    public Z mapColumns(Pair<String, String> binding) {
        this.columnBindings = Pair.toMap((Pair[])new Pair[]{Objects.requireNonNull(binding)});
        return (Z)this;
    }

    public Z mapColumns(String ownerCol, String targetCol) {
        this.columnBindings = Map.of(ownerCol, targetCol);
        return (Z)this;
    }

    protected String generateName() {
        if (this.columnBindings == null || this.columnBindings.isEmpty()) {
            throw new IllegalStateException("Column bindings have not been defined");
        }
        return this.columnBindings.entrySet().stream().map(it -> String.join((CharSequence)"_", "fk", (CharSequence)it.getKey(), (CharSequence)it.getValue())).collect(Collectors.joining("_"));
    }

    protected String getRelationshipName() {
        return Optional.ofNullable(this.name).orElse(this.generateName());
    }

    public Z setter(BiConsumer<T, K> setter) {
        this.setter = setter;
        return (Z)this;
    }
}

