/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util.schema;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.odoframework.sql.util.schema.Relation;
import net.odoframework.util.Strings;

public abstract class BaseRelationship<T, K>
implements Relation<T, K> {
    protected final String name;
    protected final String owner;
    protected final Class<K> target;
    protected Map<String, String> columnBindings;

    public BaseRelationship(String name, String owner, Class<K> target, Map<String, String> columnBindings) {
        this.name = Strings.defaultIfBlank((String)name, (String)UUID.randomUUID().toString());
        this.owner = Strings.requireNotBlank((String)owner, (String)"source is a required parameter");
        this.target = Objects.requireNonNull(target, "target is a required parameter");
        this.columnBindings = Objects.requireNonNull(columnBindings, "columnBindings is a required parameter");
        if (columnBindings.isEmpty()) {
            throw new IllegalArgumentException("there must be at least one column bindings");
        }
    }

    @Override
    public Map<String, String> getColumnBindings() {
        if (this.columnBindings == null) {
            this.columnBindings = new LinkedHashMap<String, String>();
        }
        return this.columnBindings;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Class<K> getTarget() {
        return this.target;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

