/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util;

import java.util.Map;
import java.util.stream.Collectors;
import net.odoframework.sql.BaseDBStatement;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.sql.util.schema.Table;

public class Update<T>
extends BaseDBStatement {
    private final String sql;

    public Update(Schema schema, T instance) {
        this.sql = this.generateUpdate(schema, instance);
    }

    private <T> String generateUpdate(Schema schema, T type) {
        Table<?> defn = schema.getDefn(type.getClass()).orElseThrow();
        Map<String, Object> values = defn.toMap(type);
        StringBuilder builder = new StringBuilder("update ").append(defn.getFullName()).append(" set ");
        String settall = values.keySet().stream().map(name -> name + " = ?").collect(Collectors.joining(", "));
        builder.append(settall).append('\n');
        builder.append("where \n").append(defn.getPrimarykey().whereClause());
        values.values().forEach(arg_0 -> ((Update)this).addBinding(arg_0));
        defn.getPrimarykey().populateStatement(type, this);
        return builder.toString();
    }

    public String getSql() {
        return this.sql;
    }
}

