/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.odoframework.sql.ColumnIndex;
import net.odoframework.sql.SQLSupplier;
import net.odoframework.sql.SQLWrappedException;
import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.MappedInstance;
import net.odoframework.util.Pair;

public class MappingContext {
    private final Map<String, Map<Key, MappedInstance<Object>>> context;
    private final Map<String, ColumnIndex> indexMap;

    public MappingContext(Map<String, ColumnIndex> indexMap) {
        this.indexMap = Objects.requireNonNull(indexMap, "index map");
        this.context = new LinkedHashMap<String, Map<Key, MappedInstance<Object>>>();
    }

    public <T> T set(String table, Key key, T instance) {
        return this.set(table, key, () -> instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T set(String table, Key key, SQLSupplier<T> instance) {
        Map<String, Map<Key, MappedInstance<Object>>> map = this.context;
        synchronized (map) {
            Map tableInstances = this.context.computeIfAbsent(table, k -> new LinkedHashMap());
            return tableInstances.computeIfAbsent(key, k -> new MappedInstance<Object>(SQLWrappedException.get((SQLSupplier)instance), key)).getInstance();
        }
    }

    public <T> Collection<T> get(String table) {
        return this.context.computeIfAbsent(table, k -> new LinkedHashMap()).values().stream().map(it -> it.getInstance()).collect(Collectors.toSet());
    }

    public <T> Collection<Pair<Key, MappedInstance<T>>> getInstances(String table) {
        return this.context.computeIfAbsent(table, k -> new LinkedHashMap()).entrySet().stream().map(it -> Pair.cons((Object)((Object)((Key)((Object)((Object)it.getKey())))), (Object)((MappedInstance)it.getValue()))).collect(Collectors.toSet());
    }

    public <T> Optional<T> get(String table, Key key) {
        Map<Key, MappedInstance<Object>> tableInstances = this.context.get(table);
        if (tableInstances != null) {
            return Optional.ofNullable(tableInstances.get((Object)key)).map(it -> ((MappedInstance)it).getInstance());
        }
        return Optional.empty();
    }

    public <T> Optional<MappedInstance<T>> getInstance(String table, Key key) {
        Map<Key, MappedInstance<Object>> tableInstances = this.context.get(table);
        if (tableInstances != null) {
            return Optional.ofNullable(tableInstances.get((Object)key));
        }
        return Optional.empty();
    }

    public MappingContext setReference(String table, String id, Key pk, Key foreignKey) {
        this.getInstance(table, pk).ifPresent(it -> {});
        return this;
    }

    public ColumnIndex getTableIndexMap(String table) {
        return this.getIndexMap().get(table);
    }

    public Map<String, Map<Key, MappedInstance<Object>>> getContext() {
        return this.context;
    }

    public Map<String, ColumnIndex> getIndexMap() {
        return this.indexMap;
    }
}

