/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util;

import java.util.Map;
import net.odoframework.sql.BaseDBStatement;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.sql.util.schema.Table;
import net.odoframework.util.Strings;

public class Insert<T>
extends BaseDBStatement {
    private final String sql;

    public Insert(Schema schema, T instance) {
        this.sql = this.generateInsert(schema, instance);
    }

    private <T> String generateInsert(Schema schema, T type) {
        Table<?> defn = schema.getDefn(type.getClass()).orElseThrow(() -> new IllegalArgumentException(type.getClass().getName() + " is not registered in the schema"));
        Map<String, Object> values = defn.toMap(type);
        StringBuilder builder = new StringBuilder("insert into ").append(defn.getFullName()).append(" (");
        builder.append(String.join((CharSequence)", ", values.keySet()));
        builder.append(") values (");
        builder.append(Strings.times((String)"?, ", (int)values.size()).trim()).deleteCharAt(builder.length() - 1).append(')');
        for (Object value : values.values()) {
            this.addBinding(value);
        }
        return builder.toString();
    }

    public String getSql() {
        return this.sql;
    }
}

