/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql.util;

import java.sql.ResultSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.odoframework.sql.DBStatement;
import net.odoframework.sql.SQLStatement;
import net.odoframework.sql.SQLTemplate;
import net.odoframework.sql.SQLUtils;
import net.odoframework.sql.util.Insert;
import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.MappingContext;
import net.odoframework.sql.util.Repository;
import net.odoframework.sql.util.Update;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.sql.util.schema.Table;
import net.odoframework.util.Assertions;

public abstract class DefaultRepository<T>
implements Repository<T> {
    private final Table<T> defn;
    private Class<T> type;
    private Schema schema;
    private SQLTemplate sqlTemplate;

    public DefaultRepository(Class<T> type, Schema schema, SQLTemplate sqlTemplate) {
        this.type = (Class)Assertions.notNull(type, (String)"type");
        this.schema = (Schema)Assertions.notNull((Object)schema, (String)"schema");
        this.sqlTemplate = (SQLTemplate)Assertions.notNull((Object)sqlTemplate, (String)"sqlTemplate");
        this.defn = schema.getDefn(type).orElseThrow(() -> new IllegalStateException("no definition for " + this.type + " is registered in the schema"));
    }

    @Override
    public int create(T instance) {
        Insert<T> insert = new Insert<T>(this.schema, Objects.requireNonNull(instance, "instance cannot be null"));
        return this.sqlTemplate.execute(insert);
    }

    @Override
    public int save(T instance) {
        Update<T> update = new Update<T>(this.schema, Objects.requireNonNull(instance, "instance cannot be null"));
        return this.sqlTemplate.execute(update);
    }

    @Override
    public Optional<T> get(Key key, int fetchDepth) {
        String instanceSQL = this.defn.buildJoin(fetchDepth);
        String pkClause = key.keySet().stream().map(o -> String.join((CharSequence)" = ", String.join((CharSequence)".", this.defn.getFullName(), o), "?")).collect(Collectors.joining(" and "));
        String sqlStmt = String.join((CharSequence)"\nwhere ", instanceSQL, pkClause);
        SQLStatement stmt = SQLStatement.sql((String)sqlStmt);
        for (Object value : key.values()) {
            stmt.bind(value);
        }
        return this.find((DBStatement)stmt).findFirst();
    }

    @Override
    public Stream<T> findAll(int fetchDepth) {
        String instanceSQL = this.defn.buildJoin(fetchDepth);
        SQLStatement stmt = SQLStatement.sql((String)instanceSQL);
        return this.find((DBStatement)stmt);
    }

    @Override
    public Stream<T> find(DBStatement statement) {
        AtomicReference ctx = new AtomicReference();
        return this.sqlTemplate.stream(statement, rs -> {
            if (ctx.get() == null) {
                ctx.set(new MappingContext(SQLUtils.getIndex((String)statement.getSql(), (ResultSet)rs)));
            }
            return this.defn.mapInstance((MappingContext)ctx.get(), (ResultSet)rs).getRight();
        });
    }

    public Class<T> getType() {
        return this.type;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public SQLTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    public void setSqlTemplate(SQLTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }
}

