package net.odoframework.sql.util.schema;

import net.odoframework.sql.util.Key;
import net.odoframework.sql.util.MappingContext;

import java.sql.ResultSet;
import java.util.Map;

public interface Relation<T, K> {

    void map(ResultSet rs, Schema schema, MappingContext context, Key ownerKey, T result);

    String getName();

    Map<String, String> getColumnBindings();

    String getOwner();

    Class<K> getTarget();

    default String leftJoin(Schema schema) {
        var targetTable = schema.getByType(getTarget());
        final var sql = new StringBuilder("left join ").append(targetTable.getFullName()).append(" on ");
        if (getColumnBindings() == null) {
            return "";
        }
        final var columns = new StringBuilder();
        getColumnBindings().forEach((key, value) -> {
            columns.append(" and ")
                    .append(getOwner())
                    .append('.')
                    .append(key)
                    .append(" = ")
                    .append(targetTable.getFullName())
                    .append('.')
                    .append(value);
        });
        return sql.append(columns.substring(5)).toString();
    }


}
