package net.odoframework.sql.util.schema;

import java.util.Collection;
import java.util.function.Function;

public class OneToManyBuilder<T,K> extends BaseRelationshipBuilder<T, K, OneToManyBuilder<T,K>> {

    private Function<T, ? extends Collection<K>> getter;


    public OneToManyBuilder(TableBuilder<T> builder) {
        super(builder);
    }

    public OneToManyBuilder<T,K> getter(Function<T, ? extends Collection<K>> getter) {
        this.getter = getter;
        return this;
    }

    public TableBuilder<T> create() {
        this.builder.addRelation(new OneToMany<>(getRelationshipName(), owner, target, getter, setter, columnBindings));
        return this.builder;
    }




}
