package net.odoframework.sql.util.schema;

import java.util.function.Function;

public class ManyToOneBuilder<T,K> extends BaseRelationshipBuilder<T, K, ManyToOneBuilder<T,K>> {

    private Function<T, K> getter;


    public ManyToOneBuilder(TableBuilder<T> builder) {
        super(builder);
    }

    public ManyToOneBuilder<T,K> getter(Function<T, K> getter) {
        this.getter = getter;
        return this;
    }

    public TableBuilder<T> create() {
        this.builder.addRelation(new ManyToOne<>(getRelationshipName(), owner, target, getter, setter, columnBindings));
        return this.builder;
    }




}
