package net.odoframework.sql.util.schema;


import net.odoframework.util.Strings;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class ColumnBuilder<T,K,Z> {

    private String name;
    private Function<T, K> getter;
    private BiConsumer<T, K> setter;
    private Function<Z, K> dbToObjectConverter = (z) -> (K) z;
    private Function<K, Z> objectToDbConverter = (k) -> (Z) k;
    private TableBuilder<T> tableBuilder;

    protected ColumnBuilder(TableBuilder<T> tableBuilder) {
        this.tableBuilder = Objects.requireNonNull(tableBuilder);
    }

    public ColumnBuilder<T,K,Z> name(String name) {
        this.name = Strings.requireNotBlank(name, "name cannot be empty");
        return this;
    }

    public ColumnBuilder<T,K,Z> getter(Function<T, K> getter) {
        this.getter = Objects.requireNonNull(getter, "getter cannot be null");
        return this;
    }


    public ColumnBuilder<T,K,Z> fromDb(Function<Z, K> dbToObjectConverter) {
        this.dbToObjectConverter = Objects.requireNonNull(dbToObjectConverter, "dbToObjectConverter cannot be null");
        return this;
    }

    public ColumnBuilder<T,K,Z> toDb(Function<K, Z> objectToDbConverter) {
        this.objectToDbConverter = Objects.requireNonNull(objectToDbConverter, "objectToDbConverter cannot be null");
        return this;
    }

    public ColumnBuilder<T,K,Z> setter(BiConsumer<T, K> setter) {
        this.setter = Objects.requireNonNull(setter, "setter cannot be null");
        return this;
    }

    public TableBuilder<T> create() {
        this.tableBuilder.column(new Column<T,K,Z>(name, setter, getter, dbToObjectConverter, objectToDbConverter));
        return tableBuilder;
    }
}
