package net.odoframework.sql.util.schema;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;
import net.odoframework.beans.PropertyBinding;
import net.odoframework.util.Strings;

import java.util.function.BiConsumer;
import java.util.function.Function;

import static net.odoframework.util.NullSafe.ifNullReturn;

@ToString
@EqualsAndHashCode(callSuper = true)
public class Column<T, K, Z> extends PropertyBinding<T, K> {
    @Getter
    private final String name;
    @Getter
    private final Function<Z, K> dbToObjectConverter;
    @Getter
    private final Function<K, Z> objectToDbConverter;



    @SuppressWarnings("unchecked")
    public Column(String name, BiConsumer<T, K> setter, Function<T, K> getter) {
        this(name, setter, getter, it -> (K) it, it -> (Z) it);
    }

    @SuppressWarnings("unchecked")
    public Column(String name, BiConsumer<T, K> setter, Function<T, K> getter, Function<Z, K> dbToObjectConverter, Function<K, Z> objectToDbConverter) {
        super(getter, setter);
        this.name = Strings.requireNotBlank(name, "you need to specify the column name");
        this.dbToObjectConverter = ifNullReturn(dbToObjectConverter, it -> (K) it);
        this.objectToDbConverter = ifNullReturn(objectToDbConverter, it -> (Z) it);
    }


    public Z getForDB(T instance) {
        var value = get(instance);
        return (value != null)
                ? this.getObjectToDbConverter().apply(value)
                : null;
    }

    public void setFromDB(T instance, Z dbValue) {
        K value = (dbValue != null)
                ? this.getDbToObjectConverter().apply(dbValue)
                : null;
        set(instance, value);
    }

    protected void checkValid() {

    }


    public boolean isWritable() {
        return this.setter != null;
    }

    public boolean isReadable() {
        return this.getter != null;
    }

}
