package net.odoframework.sql.util.schema;

import net.odoframework.beans.PropertyBinding;
import net.odoframework.util.Strings;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;

public abstract class BaseRelationship<T, K> implements Relation<T, K> {

    protected final String name;
    protected final String owner;
    protected final Class<K> target;
    protected Map<String, String> columnBindings;

    public BaseRelationship(String name, String owner, Class<K> target, Map<String, String> columnBindings) {
        this.name = Strings.defaultIfBlank(name, UUID.randomUUID().toString());
        this.owner = Strings.requireNotBlank(owner, "source is a required parameter");
        this.target = Objects.requireNonNull(target, "target is a required parameter");
        this.columnBindings = Objects.requireNonNull(columnBindings, "columnBindings is a required parameter");
        if (columnBindings.isEmpty()) {
            throw new IllegalArgumentException("there must be at least one column bindings");
        }
    }

    @Override
    public Map<String, String> getColumnBindings() {
        if (columnBindings == null) {
            columnBindings = new LinkedHashMap<>();
        }
        return columnBindings;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Class<K> getTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

}
