package net.odoframework.sql.util;

import net.odoframework.sql.BaseDBStatement;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.sql.util.schema.Table;

import java.util.stream.Collectors;

public class Update<T> extends BaseDBStatement {

    private final String sql;

    public Update(Schema schema, T instance) {
        sql = generateUpdate(schema, instance);
    }

    @SuppressWarnings("unchecked")
    private <T> String generateUpdate(Schema schema, T type) {
        Table<T> defn = (Table<T>) schema.getDefn(type.getClass()).orElseThrow();
        final var values = defn.toMap(type);
        final var builder = new StringBuilder("update ").append(defn.getFullName()).append(" set ");
        final var settall = values.keySet().stream().map(name -> name + " = ?").collect(Collectors.joining(", "));
        builder.append(settall).append('\n');
        builder.append("where \n")
                .append(defn
                        .getPrimarykey()
                        .whereClause());

        values.values().forEach(this::addBinding);
        defn.getPrimarykey().populateStatement(type, this);
        return builder.toString();
    }

    @Override
    public String getSql() {
        return sql;
    }


}
