package net.odoframework.sql.util;

import lombok.Getter;
import net.odoframework.util.Assertions;

public class MappedInstance<T> {

    @Getter
    private T instance;
    @Getter
    private Key primaryKey;

    public MappedInstance(T instance, Key primaryKey) {
        this.instance = Assertions.notNull(instance, "instance");
        this.primaryKey = Assertions.notNull(primaryKey, "primaryKey");
    }


    @Override
    public String toString() {
        return "MappedInstance{" +
                instance +
                '}';
    }

}
