package net.odoframework.sql.util;

import net.odoframework.sql.BaseDBStatement;
import net.odoframework.sql.util.schema.Schema;
import net.odoframework.sql.util.schema.Table;
import net.odoframework.util.Strings;

public class Insert<T> extends BaseDBStatement {

    private final String sql;

    public Insert(Schema schema, T instance) {
        sql = generateInsert(schema, instance);
    }

    @SuppressWarnings("unchecked")
    private <T> String generateInsert(Schema schema, T type) {
        Table<T> defn = (Table<T>) schema.getDefn(type.getClass()).orElseThrow(() -> new IllegalArgumentException(type.getClass().getName() + " is not registered in the schema"));
        final var values = defn.toMap(type);
        final var builder = new StringBuilder("insert into ").append(defn.getFullName()).append(" (");
        builder.append(String.join(", ", values.keySet()));
        builder.append(") values (");
        builder.append(Strings.times("?, ", values.size()).trim()).deleteCharAt(builder.length() - 1).append(')');
        for (Object value : values.values()) {
            addBinding(value);
        }
        return builder.toString();
    }

    @Override
    public String getSql() {
        return sql;
    }


}
