/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service.web;

import java.util.Map;
import java.util.Optional;
import net.odoframework.service.Response;
import net.odoframework.util.Strings;

public interface WebResponse
extends Response {
    public WebResponse status(int var1);

    default public WebResponse ok() {
        return this.status(200);
    }

    default public WebResponse created() {
        return this.status(201);
    }

    default public WebResponse userError() {
        return this.status(400);
    }

    default public WebResponse serverError() {
        return this.status(500);
    }

    default public WebResponse notFound() {
        return this.status(401);
    }

    default public boolean isFailed() {
        return this.getStatusCode() > 300;
    }

    default public WebResponse addHeader(String name, long value) {
        return this.addHeader(name, Long.toString(value));
    }

    default public WebResponse addHeader(String name, boolean value) {
        return this.addHeader(name, Boolean.toString(value));
    }

    default public WebResponse contentType(String contentType) {
        return this.addHeader("Content-Type", Strings.requireNotBlank((String)contentType, (String)"Content type is required"));
    }

    default public Optional<String> getContentType() {
        return Optional.ofNullable(this.getHeaders().get("Content-Type"));
    }

    public WebResponse addHeader(String var1, String var2);

    public WebResponse body(String var1);

    public int getStatusCode();

    public String getMessage();

    public Map<String, String> getHeaders();

    public WebResponse message(String var1);

    public String getBody();
}

