/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service.web;

import java.security.Principal;
import java.util.List;
import java.util.Optional;
import net.odoframework.container.util.Json;
import net.odoframework.service.Request;

public interface WebRequest
extends Request {
    public Optional<List<String>> getMultiValueHeader(String var1);

    public Optional<Principal> getUserPrincipal();

    public Optional<String> getHeader(String var1);

    public String getPath();

    public Optional<String> getPathVariable(String var1);

    public String getMethod();

    public boolean matches(String var1);

    public Optional<String> getQueryParam(String var1);

    public Optional<List<String>> getMultiValueQueryParam(String var1);

    default public Optional<String> getContentType() {
        return this.getHeader("Content-Type");
    }

    default public Optional<Integer> getPathVariableInt(String name) {
        return this.getPathVariable(name).map(Integer::parseInt);
    }

    default public Optional<Long> getPathVariableLong(String name) {
        return this.getPathVariable(name).map(Long::parseLong);
    }

    default public Optional<Double> getPathVariableDouble(String name) {
        return this.getPathVariable(name).map(Double::parseDouble);
    }

    default public Optional<Boolean> getPathVariableBoolean(String name) {
        return this.getPathVariable(name).map(Boolean::parseBoolean);
    }

    default public Optional<Long> getQueryParamAsLong(String name) {
        return this.getQueryParam(name).map(Long::parseLong);
    }

    default public Optional<Boolean> getQueryParamAsBoolean(String name) {
        return this.getQueryParam(name).map(Boolean::parseBoolean);
    }

    default public Optional<Double> getQueryParamAsDouble(String name) {
        return this.getQueryParam(name).map(Double::parseDouble);
    }

    public Json getJson();

    @Override
    default public <T> T getBody(Class<T> type) {
        return (T)this.getJson().unmarshal(this.getBody(), type);
    }

    public boolean pathVariablesNotSet();
}

