/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service.web;

import net.odoframework.service.ServiceFunction;
import net.odoframework.service.web.SimpleWebResponse;
import net.odoframework.service.web.WebRequest;
import net.odoframework.service.web.WebResponse;

public interface WebFunction
extends ServiceFunction<WebRequest, WebResponse> {
    default public WebResponse response() {
        return new SimpleWebResponse();
    }

    default public <T> WebResponse ok() {
        return this.response().ok();
    }

    default public WebResponse created(String locationUrl) {
        return this.response().created().addHeader("Location", locationUrl);
    }

    default public WebResponse userError() {
        return this.response().userError();
    }

    default public WebResponse serverError() {
        return this.response().serverError();
    }

    default public WebResponse notFound() {
        return this.response().notFound();
    }

    default public WebResponse unsupported(String message) {
        return this.response().status(405).body(message);
    }
}

