/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service.logging;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.odoframework.container.events.Log;
import net.odoframework.container.injection.ConfigurationProperties;
import net.odoframework.service.logging.Slf4jLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class Slf4jLoggerFactory
implements ILoggerFactory {
    private ConcurrentMap<String, Slf4jLogger> loggers = new ConcurrentHashMap<String, Slf4jLogger>();
    private Log.Level level;
    private Properties logProperties;

    public Slf4jLoggerFactory(Log.Level defaultLevel) {
        this.level = defaultLevel;
        this.logProperties = ConfigurationProperties.findByPrefix((String)"odo.log.", (boolean)true);
    }

    public Logger getLogger(String name) {
        Slf4jLogger logger = (Slf4jLogger)this.loggers.get(name);
        if (logger == null) {
            String level = this.logProperties.getProperty(name + ".level", this.level.name());
            Log.Level logLevel = Log.Level.valueOf((String)level.toLowerCase());
            logger = new Slf4jLogger(name, logLevel);
            this.loggers.put(name, logger);
        }
        return logger;
    }
}

