/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service.logging;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import net.odoframework.container.events.Log;
import net.odoframework.container.injection.ConfigurationProperties;
import net.odoframework.util.Dates;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.spi.LoggingEventBuilder;

public class Slf4jLogger
implements Logger {
    private String name;
    private Log.Level level;

    public Slf4jLogger(String name) {
        this.name = name;
    }

    public Slf4jLogger(String name, Log.Level level) {
        this(name);
        this.level = level;
    }

    public synchronized void setLevel(Log.Level level) {
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public LoggingEventBuilder makeLoggingEventBuilder(Level level) {
        return super.makeLoggingEventBuilder(level);
    }

    public boolean isEnabledForLevel(Level level) {
        return super.isEnabledForLevel(level);
    }

    public boolean isLevelEnabled(Log.Level level) {
        if (this.level == null) {
            ConfigurationProperties.getConfig();
        }
        return level.ordinal() >= this.level.ordinal();
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(Log.Level.trace);
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            Log.trace((String)this.name, (Object)msg);
        }
    }

    public void trace(String format, Object arg) {
        this.trace(this.format(format, arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(this.name, (Object)this.format(format, arg1, arg2));
    }

    public void trace(String format, Object ... arguments) {
        this.trace(this.format(format, arguments));
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            Log.publishLog((String)this.name, (Object)msg, (Log.Level)this.level, (Throwable)t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public LoggingEventBuilder atTrace() {
        return super.atTrace();
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Log.Level.debug);
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            Log.debug((String)this.name, (Object)msg);
        }
    }

    public void debug(String format, Object arg) {
        this.debug(this.format(format, arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(this.format(format, arg1, arg2));
    }

    public void debug(String format, Object ... arguments) {
        this.debug(this.format(format, arguments));
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            Log.publishLog((String)this.name, (Object)msg, (Log.Level)this.level, (Throwable)t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isLevelEnabled(Log.Level.debug);
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public LoggingEventBuilder atDebug() {
        return super.atDebug();
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Log.Level.info);
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            Log.info((String)this.name, (Object)msg);
        }
    }

    public void info(String format, Object arg) {
        this.info(this.format(format, arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(this.format(format, arg1), arg2);
    }

    public void info(String format, Object ... arguments) {
        this.info(this.format(format, arguments));
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            Log.publishLog((String)this.name, (Object)msg, (Log.Level)this.level, (Throwable)t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public LoggingEventBuilder atInfo() {
        return super.atInfo();
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Log.Level.warn);
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            Log.warn((String)this.name, (Object)msg);
        }
    }

    public void warn(String format, Object arg) {
        this.warn(this.format(format, arg));
    }

    public void warn(String format, Object ... arguments) {
        this.warn(this.format(format, arguments));
    }

    private String format(String format, Object ... arguments) {
        Object[] args = Arrays.stream(arguments).map(it -> it instanceof LocalDateTime ? Dates.toDate((LocalDateTime)((LocalDateTime)it)) : it).toArray();
        return MessageFormat.format(format, args);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(this.format(format, arg1, arg2));
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            Log.publishLog((String)this.name, (Object)msg, (Log.Level)this.level, (Throwable)t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public LoggingEventBuilder atWarn() {
        return super.atWarn();
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Log.Level.error);
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            Log.error((String)this.name, (Object)msg, null);
        }
    }

    public void error(String format, Object arg) {
        this.error(this.format(format, arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(this.format(format, arg1, arg2));
    }

    public void error(String format, Object ... arguments) {
        this.error(this.format(format, arguments));
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            Log.error((String)this.name, (Object)msg, (Throwable)t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    public LoggingEventBuilder atError() {
        return super.atError();
    }
}

