/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service;

import java.util.function.Predicate;
import javax.sql.DataSource;
import net.odoframework.container.GsonJson;
import net.odoframework.container.ModuleBuilder;
import net.odoframework.container.injection.Conditions;
import net.odoframework.container.injection.Container;
import net.odoframework.container.metrics.Metrics;
import net.odoframework.container.sql.MonitoredDefaultSQLTemplate;
import net.odoframework.container.sql.TxDataSource;
import net.odoframework.container.tx.SimpleTransactionManager;
import net.odoframework.container.tx.TxManager;
import net.odoframework.container.util.Json;
import net.odoframework.sql.SQLTemplate;

public class ServiceModule
extends ModuleBuilder {
    public void build() {
        this.provides(Json.class).with(it -> new GsonJson(it.valueAsBoolean("odo.json.prettyprinting", true)));
        this.provides(DataSource.class).with(TxDataSource::new).after((a, b) -> a.init(b.getContainer().getConfiguration())).condition(Predicate.not(Conditions.isBeanAlreadyPresent(DataSource.class)).and(Conditions.isConfigPresent((String)"odo.sql.driver").and(Conditions.isConfigPresent((String)"odo.sql.url"))));
        this.provides(SQLTemplate.class).with(it -> new MonitoredDefaultSQLTemplate((DataSource)it.references(DataSource.class), (Metrics)it.references(Metrics.class))).condition(Conditions.isBeanPresent(DataSource.class));
        this.provides(TxManager.class).with(SimpleTransactionManager::new);
    }

    private void postContainerCreated(Container container) {
    }
}

