/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service;

import java.util.Optional;
import java.util.function.BiFunction;
import net.odoframework.container.metrics.Metrics;
import net.odoframework.container.tx.TxManager;
import net.odoframework.service.Bootstrap;
import net.odoframework.service.Invocation;
import net.odoframework.service.RequestConverter;
import net.odoframework.service.ResponseConverter;
import net.odoframework.service.RuntimeContext;
import net.odoframework.service.ServiceFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProviderRuntime<T, K, Z> {
    public static final Logger LOG = LoggerFactory.getLogger(ProviderRuntime.class);

    public RequestConverter<?, K> getProviderDefaultRequestConverter();

    public ResponseConverter<?, Z> getProviderDefaultResponseConverter();

    public Invocation createInvocation(T var1);

    default public Z handleRequest(Bootstrap bootstrap, K payload, T context) {
        BiFunction<?, ?, ?> handler = bootstrap.getHandler();
        Metrics metrics = bootstrap.getMetrics();
        RequestConverter<?, ?> requestConverter = bootstrap.getRequestConverter();
        ResponseConverter<?, ?> responseConverter = bootstrap.getResponseConverter();
        Optional<TxManager> txManager = bootstrap.getTxManager();
        LOG.trace("ENTERING -> " + handler.getClass().getName());
        return (Z)metrics.doSection(this.getClass().getSimpleName(), () -> {
            try {
                RuntimeContext.set(context);
                Object request = requestConverter.apply(payload);
                Object response = null;
                response = txManager.isPresent() ? ((TxManager)txManager.get()).doInTransaction(ServiceFunction.class, () -> handler.apply(request, this.createInvocation(context))) : (Object)handler.apply(request, this.createInvocation(context));
                LOG.trace("COMPLETE -> " + handler.getClass().getName());
                Object r = responseConverter.apply(response);
                return r;
            }
            finally {
                RuntimeContext.unset();
                txManager.ifPresent(TxManager::commit);
            }
        });
    }
}

