/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.service;

import java.time.LocalDateTime;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import net.odoframework.container.events.ContainerStartedEvent;
import net.odoframework.container.events.EventPublisher;
import net.odoframework.container.injection.Container;
import net.odoframework.container.metrics.Metrics;
import net.odoframework.container.tx.TxManager;
import net.odoframework.service.ProviderRuntime;
import net.odoframework.service.RequestConverter;
import net.odoframework.service.ResponseConverter;
import net.odoframework.service.ServiceFunction;

public class Bootstrap {
    private static final ServiceLoader.Provider<Bootstrap> BOOTSTRAP = new ServiceLoader.Provider<Bootstrap>(){

        @Override
        public Class<? extends Bootstrap> type() {
            return Bootstrap.class;
        }

        @Override
        public Bootstrap get() {
            return new Bootstrap(Container.getModuleContainer());
        }
    };
    private static Bootstrap BOOTSTRAP_CACHE = null;
    private final Container container;
    private final BiFunction<?, ?, ?> handler;
    private final Optional<TxManager> txManager;
    protected final Metrics metrics;
    private final RequestConverter<?, ?> requestConverter;
    private final ResponseConverter<?, ?> responseConverter;
    protected final ProviderRuntime<?, ?, ?> runtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bootstrap getBoostrap() {
        if (BOOTSTRAP_CACHE == null) {
            ServiceLoader.Provider<Bootstrap> provider = BOOTSTRAP;
            synchronized (provider) {
                if (BOOTSTRAP_CACHE == null) {
                    BOOTSTRAP_CACHE = BOOTSTRAP.get();
                }
            }
        }
        return BOOTSTRAP_CACHE;
    }

    public Bootstrap(Container container) {
        LocalDateTime timer = LocalDateTime.now();
        try {
            this.container = container;
            this.handler = (BiFunction)container.resolve(ServiceFunction.class).orElseThrow(() -> new IllegalStateException("No " + ServiceFunction.class.getName() + " provided"));
            this.txManager = container.resolve(TxManager.class);
            this.metrics = (Metrics)container.resolve(Metrics.class).orElseThrow(() -> new IllegalStateException("No " + TxManager.class.getName() + " provided"));
            this.runtime = (ProviderRuntime)container.resolve(ProviderRuntime.class).orElseThrow(() -> new IllegalStateException("No " + ProviderRuntime.class.getName() + " provided"));
            this.requestConverter = container.resolve(RequestConverter.class).orElse(this.runtime.getProviderDefaultRequestConverter());
            this.responseConverter = container.resolve(ResponseConverter.class).orElse(this.runtime.getProviderDefaultResponseConverter());
        }
        finally {
            EventPublisher.publish((Object)new ContainerStartedEvent(timer));
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public BiFunction<?, ?, ?> getHandler() {
        return this.handler;
    }

    public Optional<TxManager> getTxManager() {
        return this.txManager;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public ProviderRuntime<?, ?, ?> getRuntime() {
        return this.runtime;
    }

    public RequestConverter<?, ?> getRequestConverter() {
        return this.requestConverter;
    }

    public ResponseConverter<?, ?> getResponseConverter() {
        return this.responseConverter;
    }

    public Object handleRequest(Object payload, Object context) {
        ProviderRuntime<?, ?, ?> runtime = this.getRuntime();
        return runtime.handleRequest(this, payload, context);
    }
}

