package net.odoframework.service.logging;

import net.odoframework.container.events.Log;
import net.odoframework.container.events.Log.Level;
import net.odoframework.container.injection.ConfigurationProperties;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Slf4jLoggerFactory implements ILoggerFactory {

    private ConcurrentMap<String, Slf4jLogger> loggers;
    private Log.Level level;
    private Properties logProperties;

    public Slf4jLoggerFactory(Log.Level defaultLevel) {
        loggers = new ConcurrentHashMap<>();
        this.level = defaultLevel;
        this.logProperties = ConfigurationProperties.findByPrefix("odo.log.", true);
    }

    @Override
    public Logger getLogger(String name) {
        var logger = loggers.get(name);
        if (logger == null) {
            var level = logProperties.getProperty(name + ".level", this.level.name());
            var logLevel = Log.Level.valueOf(level.toLowerCase());
            logger = new Slf4jLogger(name, logLevel);
            loggers.put(name, logger);
        }
        return logger;
    }
}
