package net.odoframework.service;



import net.odoframework.container.tx.TxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.BiFunction;


public interface ProviderRuntime<T, K, Z> {

    Logger LOG = LoggerFactory.getLogger(ProviderRuntime.class);

    RequestConverter<?,K> getProviderDefaultRequestConverter();

    ResponseConverter<?,Z> getProviderDefaultResponseConverter();

    Invocation createInvocation(T containerInstance);


    @SuppressWarnings("unchecked")
    default Z handleRequest(Bootstrap bootstrap, K payload, T context) {
        final BiFunction handler =  bootstrap.getHandler();
        var metrics = bootstrap.getMetrics();
        RequestConverter requestConverter = bootstrap.getRequestConverter();
        ResponseConverter responseConverter = bootstrap.getResponseConverter();
        var txManager = bootstrap.getTxManager();
        LOG.trace("ENTERING -> " + handler.getClass().getName());
        return (Z) metrics.doSection(getClass().getSimpleName(), () -> {
            try {
                RuntimeContext.set(context);
                var request = requestConverter.apply(payload);
                Object response = null;
                if (txManager.isPresent()) {
                    response = txManager
                            .get()
                            .doInTransaction(
                                    ServiceFunction.class,
                                    () -> handler.apply(request, this.createInvocation(context))
                            );
                } else {
                    response = handler.apply(request, this.createInvocation(context));
                }
                LOG.trace("COMPLETE -> " + handler.getClass().getName());
                return (Z) responseConverter.apply(response);
            } finally {
                RuntimeContext.unset();
                txManager.ifPresent(TxManager::commit);
            }
        });
    }


}
