package net.odoframework.service;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;

public class Invocation {

    private String id;
    private Object invocationContext;

    public Invocation() {
        this(UUID.randomUUID().toString(), null);
    }

    public Invocation(String id, Object invocationContext) {
        this.id = id;
        this.invocationContext = invocationContext;
    }

    public String getId() {
        return id;
    }

    @SuppressWarnings("unchecked")
    public <T> Optional<T> getUnderlyingContext(Class<T> type) {
        return Optional.ofNullable((T) this.invocationContext);
    }

    @SuppressWarnings("unchecked")
    public <T> void withContext(Consumer<T> consumer) {
        Optional.ofNullable((T) this.invocationContext).ifPresent(consumer);
    }
}
