/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.service.web;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.odoframework.util.Strings;

public class URNPath {
    private String path;
    private Map<String, String> pathElements;

    public URNPath(String pattern) {
        this.path = Strings.requireNotBlank((String)pattern, (String)"pattern is a required parameter");
    }

    public static String checkAndTrim(String str) {
        String trimmed = Strings.requireNotBlank((String)str, (String)"passed null string").trim();
        if (trimmed.startsWith("/") && trimmed.length() == 1) {
            return "";
        }
        if (trimmed.startsWith("/")) {
            trimmed = trimmed.substring(1);
        }
        if (trimmed.endsWith("/")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    public static Optional<Map<String, String>> match(String path, String pattern) {
        String[] patternElements;
        String[] pathElements = URNPath.checkAndTrim(path).split("/");
        if (pathElements.length != (patternElements = URNPath.checkAndTrim(pattern).split("/")).length) {
            return Optional.empty();
        }
        LinkedHashMap<String, String> returnMap = null;
        for (int i = 0; i < pathElements.length; ++i) {
            String index;
            String pathElement = pathElements[i].trim();
            String patternElement = patternElements[i].trim();
            boolean isVariable = URNPath.isVariable(patternElement);
            if (!pathElement.equals(patternElement) && !isVariable) {
                return Optional.empty();
            }
            String string = index = isVariable ? patternElement.substring(1, patternElement.length() - 1) : Integer.toString(i);
            if (returnMap == null) {
                returnMap = new LinkedHashMap<String, String>();
            }
            returnMap.put(index, pathElement);
        }
        return Optional.of(returnMap);
    }

    private static boolean isVariable(String patternElement) {
        return patternElement.startsWith("{") && patternElement.endsWith("}");
    }
}

