/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.service.web;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.odoframework.container.util.Json;
import org.odoframework.service.Invocation;
import org.odoframework.service.web.WebFunction;
import org.odoframework.service.web.WebRequest;
import org.odoframework.service.web.WebResponse;
import org.odoframework.util.Strings;

public abstract class HttpRouter
implements WebFunction {
    private Json json;
    private Map<String, Map<String, BiFunction<WebRequest, Invocation, WebResponse>>> handlers = new LinkedHashMap<String, Map<String, BiFunction<WebRequest, Invocation, WebResponse>>>();

    public HttpRouter(Json json) {
        this.json = Objects.requireNonNull(json, "json is a required parameter");
        this.build();
    }

    @Override
    public WebResponse apply(WebRequest s, Invocation invocation) {
        Map<String, BiFunction<WebRequest, Invocation, WebResponse>> operationHandler = this.handlers.get(s.getMethod());
        if (operationHandler == null || operationHandler.isEmpty()) {
            return this.unsupported("Unsupported Operation");
        }
        for (Map.Entry<String, BiFunction<WebRequest, Invocation, WebResponse>> function : operationHandler.entrySet()) {
            if (!s.matches(function.getKey())) continue;
            WebResponse apply = function.getValue().apply(s, invocation);
            if (apply == null) {
                return this.serverError().body("call failed");
            }
            return apply;
        }
        return this.notFound().body("NOT FOUND");
    }

    public HttpRouter addMapping(String operation, String path, BiFunction<WebRequest, Invocation, WebResponse> handler) {
        if (!this.handlers.containsKey(Strings.requireNotBlank((String)operation, (String)"operation is required"))) {
            this.handlers.put(operation, new LinkedHashMap());
        }
        this.handlers.get(operation).put(Strings.requireNotBlank((String)path, (String)"path is required"), Objects.requireNonNull(handler, "handler is required"));
        return this;
    }

    public HttpRouter get(String path, BiFunction<WebRequest, Invocation, WebResponse> handler) {
        return this.addMapping("GET", path, handler);
    }

    public HttpRouter post(String path, BiFunction<WebRequest, Invocation, WebResponse> handler) {
        return this.addMapping("POST", path, handler);
    }

    public HttpRouter put(String path, BiFunction<WebRequest, Invocation, WebResponse> handler) {
        return this.addMapping("PUT", path, handler);
    }

    public HttpRouter delete(String path, BiFunction<WebRequest, Invocation, WebResponse> handler) {
        return this.addMapping("DELETE", path, handler);
    }

    public HttpRouter head(String path, BiFunction<WebRequest, Invocation, WebResponse> handler) {
        return this.addMapping("HEAD", path, handler);
    }

    protected <T> WebResponse ok(Object body) {
        if (body instanceof String) {
            return this.response().ok().body(body.toString());
        }
        return this.response().ok().body(this.getJson().marshal(body));
    }

    protected <T> WebResponse userError(Object body) {
        if (body instanceof String) {
            return this.response().userError().body(body.toString());
        }
        return this.response().userError().body(this.getJson().marshal(body));
    }

    protected <T> WebResponse serverError(Object body) {
        if (body instanceof String) {
            return this.response().serverError().body(body.toString());
        }
        return this.response().serverError().body(this.getJson().marshal(body));
    }

    protected <T> WebResponse notFound(Object body) {
        if (body instanceof String) {
            return this.response().notFound().body(body.toString());
        }
        return this.response().notFound().body(this.getJson().marshal(body));
    }

    public abstract void build();

    public Json getJson() {
        return this.json;
    }

    public Map<String, Map<String, BiFunction<WebRequest, Invocation, WebResponse>>> getHandlers() {
        return this.handlers;
    }
}

