/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.service;

import java.util.Optional;
import java.util.logging.Logger;
import org.odoframework.container.metrics.Metrics;
import org.odoframework.container.tx.TxManager;
import org.odoframework.service.Bootstrap;
import org.odoframework.service.Invocation;
import org.odoframework.service.Request;
import org.odoframework.service.RequestConverter;
import org.odoframework.service.Response;
import org.odoframework.service.ResponseConverter;
import org.odoframework.service.RuntimeContext;
import org.odoframework.service.ServiceFunction;

public interface ProviderRuntime<T, K, Z> {
    public RequestConverter<?, K> getProviderDefaultRequestConverter();

    public ResponseConverter<?, Z> getProviderDefaultResponseConverter();

    public Invocation createInvocation(T var1);

    public Logger getLog();

    default public Z handleRequest(Bootstrap bootstrap, K payload, T context) {
        ServiceFunction<?, ?> handler = bootstrap.getHandler();
        Metrics metrics = bootstrap.getMetrics();
        RequestConverter<?, ?> requestConverter = bootstrap.getRequestConverter();
        ResponseConverter<?, ?> responseConverter = bootstrap.getResponseConverter();
        Optional<TxManager> txManager = bootstrap.getTxManager();
        this.getLog().fine("ENTERING -> " + handler.getClass().getName());
        return (Z)metrics.doSection(this.getClass().getSimpleName(), () -> {
            try {
                RuntimeContext.set(context);
                Request request = (Request)requestConverter.apply(payload);
                Response response = null;
                response = txManager.isPresent() ? (Response)((TxManager)txManager.get()).doInTransaction(ServiceFunction.class, () -> (Response)handler.apply(request, this.createInvocation(context))) : (Response)handler.apply(request, this.createInvocation(context));
                this.getLog().fine("COMPLETE -> " + handler.getClass().getName());
                Object r = responseConverter.apply(response);
                return r;
            }
            finally {
                RuntimeContext.unset();
                txManager.ifPresent(TxManager::commit);
            }
        });
    }
}

