/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.service;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;

public class Invocation {
    private String id;
    private Object invocationContext;

    public Invocation() {
        this(UUID.randomUUID().toString(), null);
    }

    public Invocation(String id, Object invocationContext) {
        this.id = id;
        this.invocationContext = invocationContext;
    }

    public String getId() {
        return this.id;
    }

    public <T> Optional<T> getUnderlyingContext(Class<T> type) {
        return Optional.ofNullable(this.invocationContext);
    }

    public <T> void withContext(Consumer<T> consumer) {
        Optional.ofNullable(this.invocationContext).ifPresent(consumer);
    }
}

