/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.service;

import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.odoframework.container.injection.Container;
import org.odoframework.container.metrics.Metrics;
import org.odoframework.container.tx.TxManager;
import org.odoframework.service.ProviderRuntime;
import org.odoframework.service.RequestConverter;
import org.odoframework.service.ResponseConverter;
import org.odoframework.service.ServiceFunction;
import org.odoframework.util.Timer;

public class Bootstrap {
    private static final ServiceLoader.Provider<Bootstrap> BOOTSTRAP = new ServiceLoader.Provider<Bootstrap>(){

        @Override
        public Class<? extends Bootstrap> type() {
            return Bootstrap.class;
        }

        @Override
        public Bootstrap get() {
            return new Bootstrap(Container.getModuleContainer());
        }
    };
    private static Bootstrap BOOTSTRAP_CACHE = null;
    private static final Logger LOG = Logger.getLogger(Bootstrap.class.getName());
    private final Container container;
    private final ServiceFunction<?, ?> handler;
    private Optional<TxManager> txManager;
    protected Metrics metrics;
    private RequestConverter<?, ?> requestConverter;
    private ResponseConverter<?, ?> responseConverter;
    protected ProviderRuntime<?, ?, ?> runtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bootstrap getBoostrap() {
        if (BOOTSTRAP_CACHE == null) {
            ServiceLoader.Provider<Bootstrap> provider = BOOTSTRAP;
            synchronized (provider) {
                if (BOOTSTRAP_CACHE == null) {
                    BOOTSTRAP_CACHE = BOOTSTRAP.get();
                }
            }
        }
        return BOOTSTRAP_CACHE;
    }

    public Bootstrap(Container container) {
        Timer timer = Timer.start();
        try {
            this.container = container;
            this.handler = (ServiceFunction)container.resolve(ServiceFunction.class).orElseThrow(() -> new IllegalStateException("No " + ServiceFunction.class.getName() + " provided"));
            this.txManager = container.resolve(TxManager.class);
            this.metrics = (Metrics)container.resolve(Metrics.class).orElseThrow(() -> new IllegalStateException("No " + TxManager.class.getName() + " provided"));
            this.runtime = (ProviderRuntime)container.resolve(ProviderRuntime.class).orElseThrow(() -> new IllegalStateException("No " + ProviderRuntime.class.getName() + " provided"));
            this.requestConverter = container.resolve(RequestConverter.class).orElse(this.runtime.getProviderDefaultRequestConverter());
            this.responseConverter = container.resolve(ResponseConverter.class).orElse(this.runtime.getProviderDefaultResponseConverter());
        }
        finally {
            LOG.fine("TIME TAKEN -> " + timer.timeTaken());
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public ServiceFunction<?, ?> getHandler() {
        return this.handler;
    }

    public Optional<TxManager> getTxManager() {
        return this.txManager;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public ProviderRuntime<?, ?, ?> getRuntime() {
        return this.runtime;
    }

    public RequestConverter<?, ?> getRequestConverter() {
        return this.requestConverter;
    }

    public ResponseConverter<?, ?> getResponseConverter() {
        return this.responseConverter;
    }

    public Object handleRequest(Object payload, Object context) {
        ProviderRuntime<?, ?, ?> runtime = this.getRuntime();
        return runtime.handleRequest(this, payload, context);
    }
}

