package org.odoframework.service;

import org.odoframework.container.GsonJson;
import org.odoframework.container.ModuleBuilder;
import org.odoframework.container.injection.Container;
import org.odoframework.container.metrics.Metrics;
import org.odoframework.container.sql.MonitoredDefaultSQLTemplate;
import org.odoframework.container.sql.SimpleDataSource;
import org.odoframework.container.sql.TxDataSource;
import org.odoframework.container.tx.SimpleTransactionManager;
import org.odoframework.container.tx.TxManager;
import org.odoframework.container.util.Json;
import org.odoframework.sql.SQLTemplate;
import org.odoframework.container.injection.Conditions;

import javax.sql.DataSource;

import static java.util.function.Predicate.not;

public class ServiceModule extends ModuleBuilder {



    @Override
    public void build() {
        provide(Json.class).with(GsonJson::new);

        provide(DataSource.class)
                .with(TxDataSource::new)
                .<TxDataSource>after((a, b) -> a.init(b.getContainer().getConfiguration()))
                .condition(
                        not(Conditions.isBeanAlreadyPresent(DataSource.class))
                                .and(Conditions.isConfigPresent(SimpleDataSource.DRIVER)
                                        .and(Conditions.isConfigPresent(SimpleDataSource.URL)))
                );

        provide(SQLTemplate.class)
                .with(it -> new MonitoredDefaultSQLTemplate(it.references(DataSource.class), it.references(Metrics.class)))
                .condition(Conditions.isBeanPresent(DataSource.class));
        provide(TxManager.class)
                .with(SimpleTransactionManager::new);
    }



    private void postContainerCreated(Container container) {

    }
}
