package org.odoframework.service;



import org.odoframework.container.tx.TxManager;

import java.util.logging.Logger;

public interface ProviderRuntime<T, K, Z> {

    RequestConverter<?,K> getProviderDefaultRequestConverter();

    ResponseConverter<?,Z> getProviderDefaultResponseConverter();

    Invocation createInvocation(T containerInstance);

    Logger getLog();

    @SuppressWarnings("unchecked")
    default Z handleRequest(Bootstrap bootstrap, K payload, T context) {
        ServiceFunction<Request,Response> handler = (ServiceFunction<Request, Response>) bootstrap.getHandler();
        var metrics = bootstrap.getMetrics();
        RequestConverter<? extends Response,K>  requestConverter = (RequestConverter<? extends Response, K>) bootstrap.getRequestConverter();
        ResponseConverter<Response,Z> responseConverter = (ResponseConverter<Response, Z>) bootstrap.getResponseConverter();
        var txManager = bootstrap.getTxManager();
        getLog().fine("ENTERING -> " + handler.getClass().getName());
        return (Z) metrics.doSection(getClass().getSimpleName(), () -> {
            try {
                RuntimeContext.set(context);
                Request request = requestConverter.apply(payload);
                Response response = null;
                if (txManager.isPresent()) {
                    response = txManager
                            .get()
                            .doInTransaction(
                                    ServiceFunction.class,
                                    () -> handler.apply(request, this.createInvocation(context))
                            );
                } else {
                    response = handler.apply(request, this.createInvocation(context));
                }
                getLog().fine("COMPLETE -> " + handler.getClass().getName());
                return (Z) responseConverter.apply(response);
            } finally {
                RuntimeContext.unset();
                txManager.ifPresent(TxManager::commit);
            }
        });
    }


}
